<?php

return [
    'name'     =>  env('APP_NAME', 'Writerap PWA'),
    'manifest' => [
        'name'              => env('APP_NAME', 'Writerap PWA'),
        'short_name'        => env('PWA_SHORT_NAME', 'PWA'),
        'start_url'         => env('PWA_URL'),
        'background_color'  => env('PWA_BG_COLOR','#ffffff'),
        'theme_color'       => env('PWA_THEME_COLOR','#000000'),
        'base_color'        => env('PWA_BASE_COLOR',''),
        'display'           => 'standalone',
        'orientation'       => 'any',
        'status_bar'        => 'black',
        'icons'             => [
            '72x72' => [
                'path'    => env('PWA_URL') . '/images/icons/icon-72x72.png',
                'purpose' => 'any'
            ],
            '96x96' => [
                'path'    => env('PWA_URL') . '/images/icons/icon-96x96.png',
                'purpose' => 'any'
            ],
            '128x128' => [
                'path'    => env('PWA_URL') . '/images/icons/icon-128x128.png',
                'purpose' => 'any'
            ],
            '144x144' => [
                'path'    => env('PWA_URL') . '/images/icons/icon-144x144.png',
                'purpose' => 'any'
            ],
            '152x152' => [
                'path'    => env('PWA_URL') . '/images/icons/icon-152x152.png',
                'purpose' => 'any'
            ],
            '192x192' => [
                'path'    => env('PWA_URL') . '/images/icons/icon-192x192.png',
                'purpose' => 'any'
            ],
            '384x384' => [
                'path'    => env('PWA_URL') . '/images/icons/icon-384x384.png',
                'purpose' => 'any'
            ],
            '512x512' => [
                'path'    => env('PWA_URL') . '/images/icons/icon-512x512.png',
                'purpose' => 'any'
            ],
        ],
        'screenshots' => [
            [
                "src" => env('APP_URL') . '/images/icons/540x720.png',
                "type" => "image/png",
                "sizes" => "540x720",
                "form_factor" => "narrow"
            ],
            [
                "src" => env('APP_URL') . '/images/icons/720x540.png',
                "type" => "image/png",
                "sizes" => "720x540",
                "form_factor" => "wide"
            ]
        ],

        'splash' => [
            '640x1136'  => '/images/icons/splash-640x1136.png',
            '750x1334'  => '/images/icons/splash-750x1334.png',
            '828x1792'  => '/images/icons/splash-828x1792.png',
            '1125x2436' => '/images/icons/splash-1125x2436.png',
            '1242x2208' => '/images/icons/splash-1242x2208.png',
            '1242x2688' => '/images/icons/splash-1242x2688.png',
            '1536x2048' => '/images/icons/splash-1536x2048.png',
            '1668x2224' => '/images/icons/splash-1668x2224.png',
            '1668x2388' => '/images/icons/splash-1668x2388.png',
            '2048x2732' => '/images/icons/splash-2048x2732.png',
        ],
        'shortcuts' => [
            
        ],
        'custom' => []
    ]
];

