<?php

namespace App\Traits\BootTrait;

use App\Models\User;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Route;
use Str;

trait CreatedByUpdatedByIdTrait
{
    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        $registerRoute = Route::has('register') ? route('register') : '';
       
        #Creating
        static::creating(function ($model) use($registerRoute){
            $model->created_by_id = userID();
            if(in_array(URL::current(), [$registerRoute]) && isAdmin()) {
                if($model->getTable() != 'users'){
                    $model->user_id = session('s_customer_id');
                    session()->forget('s_customer_id');
                }
            }
            else if($model->getTable() != 'users') {  
                if (
                    (method_exists($model, 'hasColumn') && $model->hasColumn('user_id')) ||
                        \Schema::hasColumn($model->getTable(), 'user_id')
                ) {
                    $model->user_id = getAdminOrCustomerId() ?? 1; // userID();
                }
            }

            // uuid
            if ($model->getTable() == 'chat_bots') {
                $model->uuid = (string) Str::uuid();
                $model->user_id = getAdminOrCustomerId() ?? 1; // userID();
            }
        });

        # Updating
        static::updating(function ($model){
            $model->updated_by_id = isLoggedIn() ? userID() : null;

            if($model->getTable() != 'users' && $model->getTable() != 'chat_bots') {
                $model->user_id = getAdminOrCustomerId() ?? 1; // userID();
            }
        });
    }
}
