<?php

namespace App\Http\Controllers\Admin\Settings;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use App\Http\Requests\PWASettingRequestForm;
use App\Models\SystemSetting;
use App\Services\Appearance\AppearanceService;

class PWASettingsController extends Controller
{
    public function index()
    {
        return view ('backend.admin.settings.pwa-settings');
    }

    public function store(PWASettingRequestForm $request)
    {
        $path             = public_path(). '/images/icons/';
        $start_url        = $request->start_url;      
        $public_start_url = $request->start_url;


        if ($request->icon_72) {
            $upload = $this->fileUpload($path, $request->file('icon_72'), 'pwa-icon-72x72.png', $public_start_url);

            if($upload){
               $this->storeOrUpdateSettingData('pwa_icon_72', 'images/icons/pwa-icon-72x72.png');            
           }  
          
        }
        if ($request->icon_96) {
            $upload = $this->fileUpload($path, $request->file('icon_96'), 'pwa-icon-96x96.png', $public_start_url);
            if($upload){
               $this->storeOrUpdateSettingData('pwa_icon_96', 'images/icons/pwa-icon-96x96.png');            
           }             
        }

        if ($request->icon_128) {
           $upload = $this->fileUpload($path, $request->file('icon_128'), 'pwa-icon-128x128.png', $public_start_url);
           if($upload){
               $this->storeOrUpdateSettingData('pwa_icon_128', 'images/icons/pwa-icon-128x128.png');            
           }            
        }

        if ($request->icon_144) {
           $upload = $this->fileUpload($path, $request->file('icon_144'), 'pwa-icon-144x144.png', $public_start_url);
           if($upload){
               $this->storeOrUpdateSettingData('pwa_icon_144', 'images/icons/pwa-icon-144x144.png');            
           }               
        }

        if ($request->icon_152) {
           $upload = $this->fileUpload($path, $request->file('icon_152'), 'pwa-icon-152x152.png', $public_start_url);
           
           if($upload){
               $this->storeOrUpdateSettingData('pwa_icon_152', 'images/icons/pwa-icon-152x152.png');            
           }  
        }
        if ($request->icon_192) {
           $upload =  $this->fileUpload($path, $request->file('icon_192'), 'pwa-icon-192x192.png', $public_start_url);
           if($upload){
               $this->storeOrUpdateSettingData('pwa_icon_192', 'images/icons/pwa-icon-192x192.png');            
           }       
        }
        if ($request->icon_384) {
            $upload = $this->fileUpload($path, $request->file('icon_384'), 'pwa-icon-384x384.png', $public_start_url);

           if($upload){
               $this->storeOrUpdateSettingData('pwa_icon_384', 'images/icons/pwa-icon-icon-384x384.png');            
           }         
        }

        if ($request->icon_512) {
           $upload = $this->fileUpload($path, $request->file('icon_512'), 'pwa-icon-512x512.png', $public_start_url);
            
           if($upload){
               $this->storeOrUpdateSettingData('pwa_icon_512', 'images/icons/pwa-icon-512x512.png');            
           }       
        }

        if ($request->screenshot_540) {
           $upload = $this->fileUpload($path, $request->file('screenshot_540'), 'pwa-icon-540x720.png', $public_start_url);
            
            if($upload){
               $this->storeOrUpdateSettingData('pwa_icon_540', 'images/icons/pwa-icon-540x720.png');            
           }
            
        }
        if ($request->screenshot_720) {
           $upload = $this->fileUpload($path, $request->file('screenshot_720'), 'pwa-icon-720x540.png', $public_start_url);           
           if($upload){
               $this->storeOrUpdateSettingData('pwa_icon_720', 'images/icons/pwa-icon-720x540.png');            
           }           
        }
        if(!empty($request->env)) {
            
            foreach($request->env as $key=>$value) {
               writeToEnvFile($key, $value);
            }
        }

        cacheClear();

        flash(localize('Operation successfully'))->success();
        return redirect()->route('admin.pwa-settings.index');
    }

    private function storeOrUpdateSettingData($columnName, $value)
    {
        SystemSetting::query()->updateOrCreate([
            'entity' => $columnName
        ], [
            "entity"    => $columnName,
            'value'     => $value,
            'is_active' => 1,
        ]);
        
    }

    public  function fileUpload($path, $file, $name, $start_url = null)
    {
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
        $fileName = $path . $name;
        if (file_exists($fileName)) {
            try {
                unlink($fileName);
            } catch (\Throwable $th) {}
        }

        $file->move($path, $name);
        $fileName = $path . $name;

        return $start_url.'/'.$fileName;
    }
}
