<script>
    'use strict';

    // load users
    function getDataList() {
        var callParams      = {};
        callParams.type     = "GET";
        callParams.dataType = "html";
        callParams.url      = "{{ route('admin.chat-bots.index') }}" + (gFilterObj ? '?' + $.param(gFilterObj) : '');
        callParams.data     = '';
        ajaxCall(callParams, function (result) {
            $('.data-list').empty().html(result);
            feather.replace();
        }, function onErrorData(err, type, httpStatus) {});
    }

    // handle offcanvas for adding an user
    $('body').on('click', '#addExpertFormSidebarForOffCanvas', function(e){
        e.preventDefault();
        $('#addExpertFrm .offcanvas-title').text("{{ localize('Add Chat Bot') }}");
        resetFormErrors('form#addExpertFrm');
        resetForm('form#addExpertFrm');
        $('form#addExpertFrm').attr('action', "{{ route('admin.chat-bots.store') }}");
    })

    // search
    $('body').on('click', '#searchBtn', function(){
        var search      = $('#f_search').val();
        var is_active   = $('#f_is_active :selected').val();

        gFilterObj.search    = search;
        loadingInContent('.data-list', "{{ localize('loading...') }}");
        
        if(is_active === '0' || is_active === '1') {
            gFilterObj.is_active = is_active;
        } else if(gFilterObj.hasOwnProperty('is_active')) {
            delete gFilterObj.is_active;
        }

        if(gFilterObj.hasOwnProperty('page')) {
            delete gFilterObj.page;
        }

        getDataList();
    });

    var offcanvasBottom = document.getElementById('offcanvasBottom')
    var secondoffcanvas = document.getElementById('addExpertFormSidebar')

    offcanvasBottom.addEventListener('hidden.bs.offcanvas', function() {
        var bsOffcanvas2 = new bootstrap.Offcanvas(secondoffcanvas)
        bsOffcanvas2.show()
    })
    // add user
    $("#addExpertFrm").submit(function(e) {
        e.preventDefault();

        resetFormErrors('form#addExpertFrm');
        loading('#addExpertBtn', "{{ localize('Saving...') }}");

        let id = $("#addExpertFrm #id").val();

        var callParams  = {};
        callParams.type = "POST";
        callParams.url  = $("form#addExpertFrm").attr("action");

        $('form#addExpertFrm input:hidden[name=_method]').val('POST');
        callParams.data = new FormData($('#addExpertFrm')[0]);

        callParams.processData  = false;
        callParams.contentType  = false;
        ajaxCall(callParams, function (result) {
            resetLoading('#addExpertBtn', "{{ localize('Save') }}");
            toast(result.message);
            if(!id) { // only for save
                resetForm('form#addExpertFrm');
            }
            getDataList();
            $('#addExpertFormSidebar').offcanvas('hide');

        }, function (err, type, httpStatus) {
            showFormError(err, '#addExpertFrm');
            resetLoading('#addExpertBtn', "{{ localize('Save') }}");
        });

        return false;
    });

    // edit user
    $('body').on('click', '.editIcon', function(){
        let userId = parseInt($(this).data("id"));
        let actionUrl = "chat-bots/"+userId+"/edit";
        $('#addExpertFrm .offcanvas-title').text("{{ localize('Edit Chat Bot') }}");
        $('#addExpertFormSidebar').offcanvas('show');
        resetForm('form#addExpertFrm');
        resetFormErrors('form#addExpertFrm');
        $('form#addExpertFrm').attr('action', "chat-bots/"+userId);
        $('form#addExpertFrm input:hidden[name=_method]').val('PUT');
        $('.selected-file').html('');
        var callParams  = {};
        callParams.type = "GET";
        callParams.url  = actionUrl;
        callParams.data = "";
        loadingInContent('#loader', 'loading...');
        hideElement('.offcanvas-body');
        ajaxCall(callParams, function (result) {
            resetLoading('#loader', '');
            showElement('.offcanvas-body');
            if(result.data) {
                let data = result.data;
                $('#addExpertFrm #id').val(data.id);
                $('#addExpertFrm #bot_name').val(data.bot_name);
                $('#addExpertFrm #bubble_message').val(data.bubble_message);
                $('#addExpertFrm #welcome_message').val(data.welcome_message);
                $('#addExpertFrm #instructions').val(data.instructions);
                $('#addExpertFrm #color_code').val(data.color_code);
                $('#addExpertFrm #avatar').val(data.avatar);
                $('#addExpertFrm #is_active').val(data.is_active).change();
                if(data.avatar){
                    getChosenFilesCount();
                    showSelectedFilePreviewOnLoad();
                }
            }
        }, function (err, type, httpStatus) {

        });

    });

    getDataList();

    function copyEmbeddedCode(uuid) {
        const chatScriptUrl = "{{ asset('assets/js/chat.js') }}"; 
        let html = `<script defer src="${chatScriptUrl}" data-chatbot-uuid="${uuid}"><\/script>`;
        if (navigator.clipboard?.writeText) {
            navigator.clipboard.writeText(html).then(() => {
                toast('{{ localize("Embedded code copied to clipboard!") }}');
            }).catch(err => {
                console.error("Clipboard copy failed:", err);
            });
        } else {
            // fallback
            const textarea = document.createElement("textarea");
            textarea.value = html;
            document.body.appendChild(textarea);
            textarea.select();
            document.execCommand("copy");
            document.body.removeChild(textarea);
            toast('{{ localize("Embedded code copied to clipboard!") }}');
        }
    }
</script>
