<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chat_bot_threads', function (Blueprint $table) {
            $table->id();
            $table->longText("user_id")->nullable();
            $table->text("title")->nullable();
            
            $table->integer("prompts_words")->default(0);
            $table->integer("completion_words")->default(0);
            $table->integer("total_words")->default(0);
            $table->integer("prompts_token")->default(0);
            $table->integer("completion_token")->default(0);
            $table->integer("total_token")->default(0);
            
            $table->foreignId("chat_bot_id")->nullable()->constrained('chat_bots');
            
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chat_bot_threads');
    }
};
