<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chat_bots', function (Blueprint $table) {
            $table->id();
            $table->string("bot_name");
            $table->uuid("uuid")->unique();
            $table->string("avatar")->nullable();
            $table->longText("chat_training_data")->nullable();

            $table->longText("bubble_message")->nullable();
            $table->longText("welcome_message")->nullable();
            $table->longText("instructions")->nullable();
            $table->tinyInteger("is_beyond_instructions")->default(0);

            $table->string("color_code")->nullable();
            $table->string("trigger_avatar_size")->nullable();
            $table->tinyInteger("position")->default(0)->comment("0=left,1=right");

            $table->string("iframe_width")->default("420");
            $table->string("iframe_height")->default("475");

            $table->tinyInteger("is_active")->default(1)->comment("1=Active,0=Inactive");
            
            $table->foreignId("user_id")->constrained();
            $table->foreignId("created_by_id")->nullable()->constrained("users");
            $table->foreignId("updated_by_id")->nullable()->constrained("users");
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chat_bots');
    }
};
