<?php

namespace Modules\ExternalAiChat\App\Models;

use App\Traits\BootTrait\FilterTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChatBotThreadMessage extends Model
{
    use HasFactory;
    use SoftDeletes;
    use FilterTrait;

    protected $fillable = [
        "chat_bot_id",
        "chat_bot_thread_id",
        "platform",
        "title",
        "response",
        "prompt",
        "revers_prompt",
        "file_path",
        "file_content",
        "file_embedding_content",
        "prompt_embedding_content",

        "prompts_words",
        "completion_words",
        "total_words",
        "prompts_token",
        "completion_token",
        "total_token",

        'generated_image_id',
    ];

    protected $casts = [
      "file_embedding_content"   => "array",
      "prompt_embedding_content" => "array",
    ];

    public function scopeRandomNumber($query, $random_number)
    {
        $query->where("random_number",$random_number);
    }
    public function chatBot()
    {
        return $this->belongsTo(ChatBot::class, 'chat_bot_id', 'id')->withDefault();
    }
    public function chatBotThread()
    {
        return $this->belongsTo(ChatBotThread::class, 'chat_bot_thread_id', 'id')->withDefault();
    }
}
