<?php

namespace Modules\ExternalAiChat\App\Models;

use App\Traits\BootTrait\CreatedByUpdatedByIdTrait;
use App\Traits\BootTrait\FilterTrait;
use App\Traits\Models\Status\IsActiveTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChatBot extends Model
{
    use HasFactory, SoftDeletes, IsActiveTrait, CreatedByUpdatedByIdTrait, FilterTrait;
    
    protected $fillable = [
        "user_id",
        "bot_name",
        "uuid",
        "avatar",
        "chat_training_data",
        "bubble_message",
        "welcome_message",
        "instructions",
        "is_beyond_instructions",
        "color_code",
        "trigger_avatar_size",
        "position",
        "iframe_width",
        "iframe_height",
        "is_active",
        "created_by_id",
        "updated_by_id",
        "created_at",
        "updated_at",
    ];

    public function scopeSearch($query, $search) {
        $query = $query->when($search, function($q) use ($search) {
            $q->where(function($newQ) use ($search) {
                $newQ->name($search, true, true);
            });
        });
    }

    public function scopeName($query, $name, $isLike = true, $orWhere = false) {
        $opt = "like"; $val = '%'. $name .'%';
        if(!$isLike) {
            $opt = "="; $val = $name;
        }

        $orWhere ? $query->orWhere('bot_name', $opt, $val) : $query->where('bot_name', $opt, $val);
    } 

    public function scopeIsActive($query) {
        $query->where('is_active', 1);
    }

    public function threads()
    {
        return $this->hasMany(ChatBotThread::class, 'chat_bot_id', 'id')->where('user_id', setAndGetChatbotVisitorId())->orderBy("id", "DESC");
    }
}
