<ul class="tt-side-nav">
    <li class="side-nav-item nav-item">
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon">
                <span data-feather="home" class="icon-14"></span>
            </span>
            <span class="tt-nav-link-text"><?php echo e(localize('Dashboard')); ?> </span>
        </a>
    </li>
    <?php
        $subscriptionRoutes = [
            'admin.plan-histories.index',
            'admin.plan-histories.show',
        ];
    ?>
    <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($subscriptionRoutes, 'tt-menu-item-active')); ?>">
        <a data-bs-toggle="collapse" href="#subscriptions" aria-expanded="<?php echo e(areActiveRoutes($subscriptionRoutes, 'true')); ?>" class="side-nav-link tt-menu-toggle">
            <span class="tt-nav-link-icon">
                <span data-feather="zap" class="icon-14"></span>
            </span>
            <span class="tt-nav-link-text"><?php echo e(localize('Subscriptions')); ?></span>

        </a>
        <div class="collapse <?php echo e(areActiveRoutes($subscriptionRoutes, 'show')); ?>" id="subscriptions">
            <ul class="side-nav-second-level">
                <li>
                    <a href="<?php echo e(route('admin.subscription-plans.index')); ?>"><?php echo e(localize('Subscription Packages')); ?></a>
                </li>
                <li class="<?php echo e(areActiveRoutes($subscriptionRoutes, 'tt-menu-item-active')); ?>"><a href="<?php echo e(route('admin.plan-histories.index')); ?>"><?php echo e(localize('Subscription History')); ?></a></li>
            </ul>
        </div>
    </li>

    <?php if(getSetting('enable_affiliate_system') == 1): ?>
        <li class="side-nav-item nav-item">
            <a data-bs-toggle="collapse" href="#affiliate" aria-expanded="false" class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon">
                    <span data-feather="percent" class="icon-14"></span>
                </span>
                <span class="tt-nav-link-text"><?php echo e(localize('Affiliate System')); ?></span>

            </a>
            <div class="collapse" id="affiliate">
                <ul class="side-nav-second-level">
                    <li>
                        <a href="<?php echo e(route('admin.affiliate.overview')); ?>"><?php echo e(localize('Overview')); ?></a>
                    </li>
                    <li>
                        <a
                            href="<?php echo e(route('admin.affiliate.payout.configure')); ?>"><?php echo e(localize('Payout Configuration')); ?></a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.affiliate.earnings.index')); ?>"><?php echo e(localize('Earning Histories')); ?></a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.affiliate.withdraw.index')); ?>"><?php echo e(localize('Withdraw Requests')); ?></a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.affiliate.payments.index')); ?>"><?php echo e(localize('Payment Histories')); ?></a>
                    </li>
                </ul>
            </div>
        </li>
    <?php endif; ?>

    <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
        <span class="tt-nav-title-text"><?php echo e(localize('Manage Documents')); ?></span>
    </li>

    <li class="side-nav-item nav-item">
        <a href="<?php echo e(route('admin.folders.index')); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon">
                <span data-feather="folder-plus" class="icon-14"></span>
            </span>
            <span class="tt-nav-link-text"> <?php echo e(localize('Folders')); ?> </span>
        </a>
    </li>
    <li class="side-nav-item nav-item">
        <a href="<?php echo e(route('admin.documents.index')); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon">
                <span data-feather="grid" class="icon-14"></span>
            </span>
            <span class="tt-nav-link-text"> <?php echo e(localize('Documents')); ?> </span>
        </a>
    </li>

    
    
     
    <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
        <span class="tt-nav-title-text"><?php echo e(localize('Manage Accounts')); ?></span>
    </li> 
     
    <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['admin.accounts.index'], 'tt-menu-item-active')); ?>">
        <a href="<?php echo e(route('admin.accounts.index')); ?>?type=<?php echo e(getFirstActivePlatformSlug()); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon">
                <span data-feather="target" class="icon-14"></span>
            </span>
            <span class="tt-nav-link-text"> <?php echo e(localize('Accounts')); ?> </span>
        </a>
    </li> 

    <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
        <span class="tt-nav-title-text"><?php echo e(localize('Social Posts')); ?></span>
    </li>
    
    
    <li class="side-nav-item nav-item">
        <a data-bs-toggle="collapse" href="#posts" aria-expanded="false"
            class="side-nav-link tt-menu-toggle">
            <span class="tt-nav-link-icon">
                <span data-feather="send" class="icon-14"></span>
            </span>
            <span class="tt-nav-link-text"><?php echo e(localize('Posts')); ?></span>
        </a>
        <div class="collapse" id="posts">
            <ul class="side-nav-second-level">
                <li>
                    <a href="<?php echo e(route('admin.socials.posts.create')); ?>">
                        <?php echo e(localize('Create Post')); ?>

                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('admin.socials.posts.index')); ?>">
                        <?php echo e(localize('List Posts')); ?>

                    </a>
                </li>
            </ul>
        </div>
    </li> 

     
    <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['admin.quick-texts.index'], 'tt-menu-item-active')); ?>">
        <a href="<?php echo e(route('admin.quick-texts.index')); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon">
                <span data-feather="file-text" class="icon-14"></span>
            </span>
            <span class="tt-nav-link-text"> <?php echo e(localize('Quick Texts')); ?> </span>
        </a>
    </li> 

    
    <?php if(getSetting('enable_ai_blog_wizard') == 1): ?> 
        <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
            <span class="tt-nav-title-text"><?php echo e(localize('AI Blog Posts')); ?></span>
        </li>
        <?php if(allowPlanFeature('allow_blog_wizard')): ?>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#aiArticle" aria-expanded="false"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="refresh-ccw" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('AI Articles')); ?></span>

                </a>
                <div class="collapse" id="aiArticle">
                    <ul class="side-nav-second-level">

                        <li> <a href="<?php echo e(route('admin.articles.create')); ?>"><?php echo e(localize('Generate New AI Article')); ?></a>
                        </li>


                        <li> <a href="<?php echo e(route('admin.articles.index')); ?>"><?php echo e(localize('All AI Articles')); ?></a> </li>
                    </ul>
                </div>
            </li>
        <?php endif; ?>
    <?php endif; ?>

    <?php
        $wpPostRoutes = [
            'admin.wordpress.list',
            'admin.seo.wpPostSeoChecker',
            'admin.wordpress-credentials.index',
            'admin.tags.index',
            'admin.wordpress.authorLists',
            'admin.blog-categories.index',
            "admin.wordpress.articles.edit"
        ];
    ?>
    <?php if(isModuleActive('WordpressBlog') && allowPlanFeature('allow_wordpress')): ?>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($wpPostRoutes, 'tt-menu-item-active')); ?>">
            <a data-bs-toggle="collapse" href="#wpPosts" aria-expanded="<?php echo e(areActiveRoutes($wpPostRoutes, 'true')); ?>"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon">
                    <span data-feather="list" class="icon-14"></span>
                </span>
                <span class="tt-nav-link-text"><?php echo e(localize('WordPress Posts')); ?></span>
            </a>
            <div class="collapse <?php echo e(areActiveRoutes($wpPostRoutes, 'show')); ?>" id="wpPosts">
                <ul class="side-nav-second-level">
                    <li class="<?php echo e(areActiveRoutes(['admin.wordpress.list',"admin.wordpress.articles.edit", 'admin.seo.wpPostSeoChecker'], 'tt-menu-item-active wordpressImportedPosts')); ?>">
                        <a href="<?php echo e(route('admin.wordpress.list')); ?>"><?php echo e(localize('WordPress Imported Posts')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.blog-categories.index')); ?>">
                            <?php echo e('Wordpress Category'); ?>

                        </a>
                    </li> 
                    <li>
                        <a href="<?php echo e(route('admin.tags.index')); ?>">
                            <?php echo e('Wordpress Tags'); ?>

                        </a>
                    </li>  
                    <li>
                        <a href="<?php echo e(route('admin.wordpress.authorLists')); ?>">
                            <?php echo e('Wordpress Author'); ?>

                        </a>
                    </li>  
                    <li>
                        <a href="<?php echo e(route('admin.wordpress-credentials.index')); ?>">
                            <?php echo e('Wordpress Setting'); ?>

                        </a>
                    </li> 
                </ul>
            </div>
        </li>
    <?php endif; ?>

    <?php if(getSetting('enable_ai_chat') == 1 || getSetting('enable_ai_chat_image') == 1 || getSetting('enable_ai_vision') == 1 || getSetting('enable_ai_pdf_chat') == 1 || getSetting('enable_generate_code') == 1): ?>
        <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
            <span class="tt-nav-title-text"><?php echo e(localize('AI Chat')); ?></span>
        </li>
        <li class="side-nav-item nav-item">
            <a data-bs-toggle="collapse" href="#aiWords" aria-expanded="false" class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon">
                    <span data-feather="message-circle" class="icon-14"></span>
                </span>
                <span class="tt-nav-link-text"><?php echo e(localize('AI Chat')); ?></span>

            </a>
            <div class="collapse" id="aiWords">
                <ul class="side-nav-second-level"> 
                    <?php if(allowPlanFeature('allow_ai_chat') && getSetting('enable_ai_chat') == 1): ?>
                        <li>
                            <a href="<?php echo e(getFirstActiveChatExpertId() != null ? route('admin.chats.index').'?chat_expert_id='.getFirstActiveChatExpertId() : route('admin.chats-expert.index')); ?>">
                                <?php echo e(localize('AI Expert Chat')); ?>

                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(allowPlanFeature('allow_ai_image_chat') && getSetting('enable_ai_chat_image') == 1 ): ?>
                        <li> <a href="<?php echo e(route('admin.chats.aiImageChat')); ?>"><?php echo e(__('AI Image Chat')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if(allowPlanFeature('allow_ai_vision') && getSetting('enable_ai_vision') == 1): ?>
                        <li>
                            <a href="<?php echo e(route('admin.chats.aiVisionChat')); ?>"><?php echo e(localize('AI Vision')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if(allowPlanFeature('allow_ai_pdf_chat') && getSetting('enable_ai_pdf_chat') == 1): ?>
                        <li>
                            <a href="<?php echo e(route('admin.chats.aiPDFChat')); ?>"><?php echo e(localize('AI PDF Chat')); ?></a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if(allowPlanFeature('allow_ai_code') && getSetting('enable_generate_code') == 1): ?>
                        <li> <a
                                href="<?php echo e(route('admin.openai.chats.code-generator')); ?>"><?php echo e(localize('AI Code Generate')); ?></a>
                        </li>
                    <?php endif; ?>

                </ul>
            </div>
        </li>
    <?php endif; ?>
    
    
    <?php if(getSetting('enable_templates') == 1 || getSetting('enable_ai_writer') == 1 || getSetting('enable_ai_rewriter') == 1): ?> 
        <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
            <span class="tt-nav-title-text"><?php echo e(localize('AI Contents')); ?></span>
        </li>
        <?php if(allowPlanFeature('allow_templates') && getSetting('enable_templates') == 1): ?>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#templates" aria-expanded="false"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="file-text" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"> <?php echo e(localize('Templates')); ?></span>
                </a>
                <div class="collapse" id="templates">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('admin.templates.index')); ?>">
                                <?php echo e(localize('Templates')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('admin.template-categories.index')); ?>">
                                <?php echo e(localize('Template Categories')); ?>

                            </a>
                        </li>
                    </ul>
                </div>
            </li>
        <?php endif; ?>

        <?php if(allowPlanFeature('allow_ai_writer') && getSetting('enable_ai_writer') == 1): ?>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#aiWriter" aria-expanded="false" class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="pen-tool" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('AI Writer')); ?></span>
                </a>
                <div class="collapse" id="aiWriter">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('admin.ai-writer.create')); ?>">
                                <?php echo e(localize('AI Writer')); ?>

                            </a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('admin.ai-writer.index')); ?>">
                                <?php echo e(localize('All AI Writer ')); ?>

                            </a>
                        </li>
                    </ul>
                </div>
            </li>
        <?php endif; ?>

        <?php if(allowPlanFeature('allow_ai_rewriter')): ?>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#aiReWriter" aria-expanded="false" class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="pen-tool" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('AI ReWriter')); ?></span>

                </a>
                <div class="collapse" id="aiReWriter">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('admin.ai-rewriter.create')); ?>">
                                <?php echo e(localize('AI ReWriter')); ?>

                            </a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('admin.ai-rewriter.index')); ?>">
                                <?php echo e(localize('All ReWriter ')); ?>

                            </a>
                        </li>
                    </ul>
                </div>
            </li>
        <?php endif; ?> 
    <?php endif; ?>

    <?php if(getSetting('enable_ai_images') == 1): ?> 
        <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
            <span class="tt-nav-title-text"><?php echo e(localize('AI Images')); ?></span>
        </li>
        <?php if(allowPlanFeature('allow_images')): ?>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#aiImage" aria-expanded="false" class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="image" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(__('AI Images')); ?></span>

                </a>
                <div class="collapse" id="aiImage">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('admin.images.index')); ?>"><?php echo e(localize('All AI Images')); ?></a>
                        </li>
                    </ul>
                </div>
            </li>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(getSetting('enable_ai_plagiarism') == 1): ?> 
        <?php if(allowPlanFeature('allow_ai_plagiarism')): ?>
            <li class="side-nav-item nav-item">
                <a href="<?php echo e(route('admin.ai-plagiarism.index')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon">
                        <span data-feather="file-minus" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"> <?php echo e(localize('AI Plagiarism')); ?> </span>
                </a>
            </li>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(getSetting('enable_ai_detector') == 1): ?> 
        <?php if(allowPlanFeature('allow_ai_detector')): ?>
            <li class="side-nav-item nav-item">
                <a href="<?php echo e(route('admin.ai-detector.index')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon">
                        <span data-feather="type" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"> <?php echo e(localize('AI Detector')); ?> </span>
                </a>
            </li>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(getSetting('enable_ai_product_shot') == 1): ?> 
        
        <?php if(allowPlanFeature('allow_ai_product_shot')): ?>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#aiProductShot" aria-expanded="false"
                class="side-nav-link tt-menu-toggle">
                            <span class="tt-nav-link-icon">
                                <span data-feather="image" class="icon-14"></span>
                            </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('AI Product Shot')); ?></span>

                </a>
                <div class="collapse" id="aiProductShot">
                    <ul class="side-nav-second-level">
                        <?php if(allowPlanFeature('allow_ai_product_shot')): ?>
                            <li> <a href="<?php echo e(route('admin.images.productShot.index')); ?>"><?php echo e(localize('AI Product Shot')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(getSetting('enable_ai_photo_studio') == 1): ?> 
        
        <?php if(allowPlanFeature('allow_ai_photo_studio')): ?>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#aiPhotoStudio" aria-expanded="false"
                class="side-nav-link tt-menu-toggle">
                            <span class="tt-nav-link-icon">
                                <span data-feather="image" class="icon-14"></span>
                            </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('AI Photo Studio')); ?></span>

                </a>
                <div class="collapse" id="aiPhotoStudio">
                    <ul class="side-nav-second-level">
                        <?php if(allowPlanFeature('allow_ai_photo_studio')): ?>
                            <li> <a href="<?php echo e(route('admin.images.photoStudio.index')); ?>"><?php echo e(localize('AI Photo Studio List')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
        <?php endif; ?>
    <?php endif; ?>
    <?php if(getSetting('enable_ai_video') == 1 || getSetting('enable_ai_avatar_pro') == 1): ?> 
      
        <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
            <span class="tt-nav-title-text"><?php echo e(localize('AI Videos')); ?></span>
        </li>
        <?php if(allowPlanFeature('allow_ai_video') && getSetting('enable_ai_video') == 1): ?>
            <?php
                $videoRoutes = ['admin.videos.index'];
            ?>

            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#aiVideo" aria-expanded="false" class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="film" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('AI Video')); ?></span>

                </a>
                <div class="collapse" id="aiVideo">
                    <ul class="side-nav-second-level">
                        <li> <a href="<?php echo e(route('admin.videos.index')); ?>"><?php echo e(localize('All AI Video')); ?></a>
                        </li>
                    </ul>
                </div>
            </li>
            
        <?php endif; ?>

        
        <?php if(allowPlanFeature('allow_ai_avatar_pro') && getSetting('enable_ai_avatar_pro') == 1): ?>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#aiAvatarPro" aria-expanded="false"
                class="side-nav-link tt-menu-toggle">
                            <span class="tt-nav-link-icon">
                                <span data-feather="film" class="icon-14"></span>
                            </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('AI Avatar Pro')); ?></span>
                </a>

                <div class="collapse" id="aiAvatarPro">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('admin.avatarPro.index')); ?>"><?php echo e(localize('AI Avatar Pro')); ?></a>
                        </li>
                    </ul>
                </div>
            </li>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(getSetting('enable_speech_to_text') == 1 || getSetting('enable_text_to_speech') == 1): ?> 
    
        <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
            <span class="tt-nav-title-text"><?php echo e(localize('AI Voices')); ?></span>
        </li>

        <?php if(allowPlanFeature('allow_text_to_speech') && getSetting('enable_text_to_speech') == 1): ?>
            <li class="side-nav-item nav-item">
                <a href="<?php echo e(route('admin.text-to-speeches.index')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon">
                        <span data-feather="volume-2" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"> <?php echo e(localize('Text To Speech')); ?> </span>
                </a>
            </li>
        <?php endif; ?>

        <?php if(allowPlanFeature('allow_speech_to_text') && getSetting('enable_speech_to_text') == 1): ?>
            <li class="side-nav-item nav-item">
                <a href="<?php echo e(route('admin.voice-to-text.create')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon">
                        <span data-feather="mic" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"> <?php echo e(localize('Speech to Text')); ?> </span>
                </a>
            </li>
        <?php endif; ?>
    <?php endif; ?>

    

    <?php if(allowPlanFeature('has_free_support')): ?>
        <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
            <span class="tt-nav-title-text"><?php echo e(localize('Support')); ?></span>
        </li>

        <li class="side-nav-item nav-item">
            <a data-bs-toggle="collapse" href="#supportTicketManagement" aria-expanded="false"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon">
                    <span data-feather="headphones" class="icon-14"></span>
                </span>
                <span class="tt-nav-link-text"><?php echo e(localize('Support Ticket')); ?></span>
            </a>
            <div class="collapse" id="supportTicketManagement">
                <ul class="side-nav-second-level">
                    <li> <a href="<?php echo e(route('admin.support-tickets.index')); ?>"><?php echo e(localize('Tickets')); ?></a>
                    </li>

                </ul>
            </div>
        </li>
    <?php endif; ?>

    <?php
        $roleManagements = ['admin.users.index', 'admin.roles.index'];
    ?>

    <?php if(allowPlanFeature('allow_team')): ?>
        <li class="side-nav-item nav-item">
            <a data-bs-toggle="collapse" href="#userROleManagement" aria-expanded="false"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon">
                    <span data-feather="user-check" class="icon-14"></span>
                </span>
                <span class="tt-nav-link-text"><?php echo e(localize('Team')); ?></span>
            </a>
            <div class="collapse" id="userROleManagement">
                <ul class="side-nav-second-level">
                        <li> <a href="<?php echo e(route('admin.roles.index')); ?>"><?php echo e(localize('Team Roles')); ?></a></li>
                        <li> <a href="<?php echo e(route('admin.users.index')); ?>"><?php echo e(localize('Team Members')); ?></a> </li>
                </ul>
            </div>
        </li>
    <?php endif; ?>

    <li class="side-nav-title side-nav-item nav-item mt-4">
        <span class="tt-nav-title-text"><?php echo e(localize('Reports')); ?></span>
    </li>
    <!-- Report -->
    <li class="side-nav-item nav-item ">
        <a data-bs-toggle="collapse" href="#reports" aria-expanded="false" class="side-nav-link tt-menu-toggle">
            <span class="tt-nav-link-icon"><i data-feather="bar-chart" class="icon-14"></i></span>
            <span class="tt-nav-link-text"><?php echo e(localize('Reports')); ?></span>
        </a>
        <div class="collapse" id="reports">
            <ul class="side-nav-second-level">
                <li>
                    <a href="<?php echo e(route('admin.reports.words')); ?>"><?php echo e(localize('Words Report')); ?></a>
                </li>

                <li>
                    <a href="<?php echo e(route('admin.reports.codes')); ?>"><?php echo e(localize('Codes Report')); ?></a>
                </li>

                <li>
                    <a href="<?php echo e(route('admin.reports.images')); ?>"><?php echo e(localize('Images Report')); ?></a>
                </li>

                <li>
                    <a href="<?php echo e(route('admin.reports.s2t')); ?>"><?php echo e(localize('Speech to Texts')); ?></a>
                </li>

                <li>
                    <a href="<?php echo e(route('admin.reports.mostUsed')); ?>"><?php echo e(localize('Most Used Templates')); ?></a>
                </li>

                <li>
                    <a href="<?php echo e(route('admin.reports.subscriptions')); ?>"><?php echo e(localize('Subscriptions Reports')); ?></a>
                </li>


            </ul>
        </div>
    </li>
</ul>
<?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/common/customer-sidebar.blade.php ENDPATH**/ ?>