<section class="template-1 pt-60 pb-60">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="d-inline-block text-center px-5 py-1 rounded-pill border border-1 border-primary mb-4">
                    <p class="fs-14 fw-normal mb-0"><?php echo e(localize('Template')); ?></p>
                </div>

                <h2 class="fs-48 mb-3"><?php echo e(localize('Ultimate tool for Social Media growth')); ?></h2>
                <p class="max-text-60 mb-5"><?php echo e(localize('Create unlimited short videos at once. Auto generate captions, effects, background and music for you.')); ?></p>
            </div>
        </div>
        <div class="row g-0">
            <div class="col-12">
                <div class="template-tab">
                    <ul class="nav nav-pills gap-3 px-3 py-5 rounded-2" id="myTab" role="tablist">

                        <li class="nav-item" role="presentation">
                            <a href="#"
                               class="nav-link text-body px-5 rounded-pill getTemplates active"
                               data-bs-toggle="pill"
                               data-bs-target="#template-1"
                               type="button"
                               role="tab"
                               aria-selected="true">
                                <span class="d-flex align-items-center gap-2">
                                <img src="<?php echo e(asset('frontend/assets/img/shape/template-icon-1.png')); ?>" alt="icon" class="img-fluid">
                                <img src="<?php echo e(asset('frontend/assets/img/shape/template-icon-1-color.png')); ?>" alt="icon" class="img-fluid">
                                <?php echo e(localize('All')); ?>

                            </span>
                            </a>
                        </li>

                        <?php $__currentLoopData = $template_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item" role="presentation">
                                <a href="#"
                                   class="nav-link text-body px-5 rounded-pill getTemplates"
                                   data-id="<?php echo e($category->id); ?>"
                                   data-bs-toggle="pill"
                                   data-bs-target="#<?php echo e($category->slug); ?>"
                                   type="button"
                                   role="tab"
                                   aria-selected="true">
                                    <span class="d-flex align-items-center gap-2">
                                        <?php if($category->icon): ?>
                                            <?php echo $category->icon; ?>

                                        <?php else: ?>
                                            <img src="<?php echo e(asset('frontend/')); ?>/assets/img/shape/template-icon-2.png"
                                                 alt="icon"
                                                 class="img-fluid">
                                            <img src="<?php echo e(asset('frontend/')); ?>/assets/img/shape/template-icon-2-color.png"
                                                 alt="icon"
                                                 class="img-fluid">
                                        <?php endif; ?>
                                        <?php echo e($category->category_name); ?>

                                    </span>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                    <div class="tab-content mt-10" id="myTabContent">
                        <div class="tab-pane fade active show" id="template-1" role="tabpanel">
                            <div class="row g-3" id="renderTemplates">
                               
                            </div>

                            <div class="text-center position-relative z-1">
                                <a href="<?php echo e(route('admin.templates.index')); ?>"
                                   class="btn btn-outline-light rounded-pill border-light border-opacity-25 fw-semibold d-inline-flex align-items-center gap-2 text-light">
                                    <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="0.904541" width="24" height="24" rx="12" fill="url(#paint0_linear_1780_21102)"></rect>
                                        <path d="M7.34365 11.6523C7.34365 11.6523 13.3527 11.6523 18.7722 11.6523M18.7722 11.6523C14.8572 11.6523 14.1345 7.65234 14.1345 7.65234M18.7722 11.6523C14.8572 11.6523 14.1345 15.6523 14.1345 15.6523" stroke="white" stroke-width="1.1"></path>
                                        <defs>
                                            <linearGradient id="paint0_linear_1780_21102" x1="0.904541" y1="12" x2="24.9045" y2="12" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#202877"></stop>
                                                <stop offset="0.360189" stop-color="#372E95"></stop>
                                                <stop offset="0.536415" stop-color="#5331B1"></stop>
                                                <stop offset="1" stop-color="#9629E6"></stop>
                                            </linearGradient>
                                        </defs>
                                    </svg>
                                    <?php echo e(localize('Try it Now')); ?>

                                </a>
                            </div>
                        </div>
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
</section><?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/frontend/default/pages/partials/template-section.blade.php ENDPATH**/ ?>