<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <!--required meta tags-->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!--meta-->
    <meta name="description" content="<?php echo $__env->yieldContent('description', 'WriteBot ai content generator and writing assistant for saas platform'); ?>)">
    <meta name="keywords" content="<?php echo $__env->yieldContent('keywords', 'ai, ai assistant, ai content writer, ai copywriting, ai image generator, ai speech to text, ai writer, chat gpt3, chatgpt, content generation, dall-e, openai, openai dalle, openai davinci, Text Generation'); ?>)">
    <meta name="author" content="ThemeTags">
    <?php echo $__env->yieldContent('meta'); ?>
    <!--favicon icon-->
    <link rel="icon" href="<?php echo e(avatarImage(getSetting('favicon')) ?? asset('assets/img/favicon.png')); ?>" type="image/png" sizes="16x16">

    <!--title-->
    <title><?php echo $__env->yieldContent('title', config('app.name', 'Laravel')); ?></title>
    
    <?php if(getSetting('enable_recaptcha') == 1): ?>
        <?php echo RecaptchaV3::initJs(); ?>

    <?php endif; ?>
    <!--build:css-->
    <?php echo $__env->make('common.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- endbuild -->

    <?php echo $__env->yieldPushContent('css'); ?>

</head>

<body>
    <?php if(getSetting('enable_preloader') !=0): ?>
        <!--preloader start-->
        <?php echo $__env->make('common.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!--preloader end-->
    <?php endif; ?>
    
    <!--enable_cookie_consent-->
    <?php if(getSetting('enable_cookie_consent') == '1'): ?>
        <div class="cookie-alert">
            <div class="p-3 bg-white rounded shadow-lg">
                <div class="mb-3">
                    <?php echo getSetting('cookie_consent_text'); ?>

                </div>
                <button class="btn btn-primary cookie-accept">
                    <?php echo e(localize('I Understood')); ?>

                </button>
            </div>
        </div>
    <?php endif; ?>
    
    <!--main content wrapper start-->
    <section class="d-flex align-items-center position-relative bg-secondary-subtle min-vh-100">

        <!--login registration section start-->
        <div class="container">
          
            <?php echo $__env->yieldContent('content'); ?>

        </div>
        <!--login registration section end-->

    </section>
    <!--main content wrapper end-->

    <!--build:js-->
    <?php echo $__env->make('common.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/layouts/login.blade.php ENDPATH**/ ?>