<div class="offline_payment d-none" id="offline_payment">
    <div class="row">

        <div class="col-md-12">
            <div class="mb-4">
                <label for="payment_method" class="form-label"><?php echo e(localize('Payment Method')); ?> <span
                        class="text-danger ms-1">*</span></label>
                <select class="form-control select2 offline_payment_method" id="offline_payment_method"
                    name="offline_payment_method" data-toggle="select2">
                    <option value=""><?php echo e(localize('Select Offline Payment Method')); ?></option>
                    <?php $__currentLoopData = $offlinePaymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offlinePaymentMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($offlinePaymentMethod->id); ?>">
                            <?php echo e($offlinePaymentMethod->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <div class="col-md-12">
            <div class="mb-4">
                <label for="name" class="form-label text-center all-description d-none"><?php echo e(localize('Description')); ?>

                    <span class="text-danger ms-1">*</span></label>
                <?php $__currentLoopData = $offlinePaymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offlinePaymentMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <p id="description_<?php echo e($offlinePaymentMethod->id); ?>" class="all-description d-none">
                        <?php echo nl2br(e($offlinePaymentMethod->description)); ?></p>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

    </div>


    <div class="mb-4">
        <label class="form-label"><?php echo e(localize('Payment Details')); ?> <span class="text-danger ms-1">*</span></label>
        <textarea class="form-control" name="payment_detail" id="offline_payment_detail" rows="2"
            placeholder="<?php echo e(localize('Type your Payment Details')); ?>"></textarea>
        <?php if($errors->has('payment_detail')): ?>
            <span class="text-danger"><?php echo e($errors->first('payment_detail')); ?></span>
        <?php endif; ?>
    </div>

    <div class="mb-3">
        <label for="default_creativity" class="form-label"><?php echo e(localize('File')); ?>

        </label>


        <div class="file-drop-area file-upload text-center rounded-3">
            <input type="file" class="file-drop-input" name="file" id="offline_file" />
            <div class="file-drop-icon ci-cloud-upload">
                <i data-feather="image"></i>
            </div>
            <p class="text-dark fw-bold mb-2 mt-3">
                <?php echo e(localize('Drop your files here or')); ?>

                <a href="javascript::void(0);" class="text-primary"><?php echo e(localize('Browse')); ?></a>
            </p>
            <p class="mb-0 file-name text-muted">

                <small>* <?php echo e(localize('Allowed file types: jpg,png,jpeg')); ?>

                </small>


            </p>
        </div>
        <?php if($errors->has('file')): ?>
            <span class="text-danger"><?php echo e($errors->first('file')); ?></span>
        <?php endif; ?>
    </div>
    <div class="mb-4">
        <label class="form-label"><?php echo e(localize('Note')); ?></label>
        <textarea class="form-control" name="note" id="offline_note" rows="1"
            placeholder="<?php echo e(localize('Type your Note')); ?>"></textarea>
        <?php if($errors->has('note')): ?>
            <span class="text-danger"><?php echo e($errors->first('note')); ?></span>
        <?php endif; ?>
    </div>
    <div class="d-flex justify-content-between center">
        <button type="button" class="btn btn-secondary mt-4 px-5 cancel"><?php echo e(localize('Cancel')); ?></button>
        <button type="submit" class="btn btn-primary mt-4 px-5"><?php echo e(localize('Proceed')); ?></button>
    </div>

</div>
<?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/frontend/common/_offline_payment.blade.php ENDPATH**/ ?>