<table class="table tt-footable align-middle" data-use-parent-width="true">
    <thead>
        <tr>
            <th class="text-center"><?php echo e(localize('S/L')); ?></th>
            <th><?php echo e(localize('User')); ?></th>
            <th data-breakpoints="xs sm"><?php echo e(localize('Date')); ?></th>
            <th data-breakpoints="xs sm"><?php echo e(localize('Amount')); ?></th>
            <th data-breakpoints="xs sm"><?php echo e(localize('Payment Method')); ?></th>
            <th data-breakpoints="xs sm"><?php echo e(localize('Status')); ?></th>
            <th data-breakpoints="xs sm lg"><?php echo e(localize('Additional Info')); ?></th>
            <th data-breakpoints="xs sm lg"><?php echo e(localize('Remarks')); ?></th>
            <?php if(auth()->user()->user_type != 'customer'): ?>
                <th data-breakpoints="xs sm" class="text-end"><?php echo e(localize('Action')); ?></th>
            <?php endif; ?>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $paymentHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="text-center">
                    <?php echo e($key + 1 + ($paymentHistories->currentPage() - 1) * $paymentHistories->perPage()); ?>

                </td>
                <td>
                    <a href="javascript:void(0);" class="d-flex align-items-center">
                        <div class="avatar avatar-sm">
                            <img class="rounded-circle" src="<?php echo e(urlVersion($history->user->avatar)); ?>"
                                alt=""
                                onerror="this.onerror=null;this.src='<?php echo e(staticAsset('backend/assets/img/placeholder-thumb.png')); ?>';" />
                        </div>
                        <h6 class="fs-sm mb-0 ms-2"><?php echo e($history->user->name); ?>

                        </h6>
                    </a>
                </td>

                <td>
                    <?php echo e(date('d M, Y', strtotime($history->created_at))); ?>

                </td>

                <td>
                    <?php echo e(formatPrice($history->amount)); ?>

                </td>

                <td>
                    <?php echo e(ucwords(str_replace('_', ' ', $history->payment_method))); ?>

                </td>

                <td>
                    <?php if($history->status == 'requested'): ?>
                        <span class="badge bg-soft-primary rounded-pill text-capitalize">
                            <?php echo e($history->status); ?>

                        </span>
                    <?php elseif($history->status == 'paid'): ?>
                        <span class="badge bg-soft-success rounded-pill text-capitalize">
                            <?php echo e($history->status); ?>

                        </span>
                    <?php else: ?>
                        <span class="badge bg-soft-danger rounded-pill text-capitalize">
                            <?php echo e($history->status); ?>

                        </span>
                    <?php endif; ?>
                </td>

                <td>
                    <?php if($history->additional_info): ?>
                        <?php echo e($history->additional_info); ?>

                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>

                <td>
                    <?php if($history->remarks): ?>
                        <?php echo e($history->remarks); ?>

                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>

                <?php if(auth()->user()->user_type != 'customer'): ?>
                    <td class="text-end">
                        <?php if($history->status != 'cancelled' && $history->status != 'paid'): ?>
                            <div class="dropdown tt-tb-dropdown">
                                <button type="button" class="btn p-0" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i data-feather="more-vertical"></i>
                                </button>
                                <div class="dropdown-menu dropdown-menu-end shadow">

                                    <a class="dropdown-item" href="javascript::void(0);" data-bs-toggle="modal"
                                        data-bs-target="#withdraw-modal-<?php echo e($history->id); ?>">
                                        <i data-feather="credit-card"
                                            class="me-2"></i><?php echo e(localize('Cancel or Pay Now')); ?>

                                    </a>
                                </div>
                            </div>
                        <?php else: ?>
                            <span
                                class="badge bg-soft-danger rounded-pill text-capitalize"><?php echo e(localize('N/A')); ?></span>
                        <?php endif; ?>
                    </td>
                <?php endif; ?>

            </tr>

            <?php if(auth()->user()->user_type != 'customer'): ?>
                
                <div id="withdraw-modal-<?php echo e($history->id); ?>" class="modal fade modalParentSelect2">
                    <div class="modal-dialog modal-md modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title"><?php echo e(localize('Cancel Or Pay Now')); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-hidden="true"></button>
                            </div>
                            <div class="modal-body">
                                <?php
                                    $payoutAccount = \App\Models\AffiliatePayoutAccount::where('user_id', $history->user_id)
                                        ->where('payment_method', $history->payment_method)
                                        ->first();
                                ?>
                                <div class="mb-3">
                                    <?php echo e(localize('Payment Method')); ?>: <span
                                        class="badge bg-soft-success rounded-pill text-capitalize">
                                        <?php echo e(ucwords(str_replace('_', ' ', $history->payment_method))); ?>

                                    </span>
                                </div>

                                <div class="mb-3">
                                    <?php echo e(localize('Account Details')); ?>: <?php echo e($payoutAccount->account_details); ?>

                                </div>

                                <?php if($history->additional_info): ?>
                                    <div class="mb-3">
                                        <?php echo e(localize('Additional Info')); ?>: <?php echo e($history->additional_info); ?>

                                    </div>
                                <?php endif; ?>

                                <form action="<?php echo e(route('affiliate.withdraw.update')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="id" value=<?php echo e($history->id); ?>>

                                    <div class="mb-3">
                                        <label for="status" class="form-label">
                                            <?php echo e(localize('Status')); ?>

                                            <small class="text-danger">*</small>
                                        </label>
                                        <select class="form-select modalSelect2" id="status" name="status" required>
                                            <option value="">
                                                <?php echo e(localize('Change status to')); ?>

                                            </option>

                                            <option value="paid">
                                                <?php echo e(localize('Paid')); ?>

                                            </option>

                                            <option value="cancelled">
                                                <?php echo e(localize('Cancelled')); ?>

                                            </option>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="remarks" class="form-label"><?php echo e(localize('Remarks')); ?></label>
                                        <textarea id="remarks" name="remarks" class="form-control" placeholder="<?php echo e(localize('Type remarks')); ?>"></textarea>
                                    </div>

                                    <div class="mb-3">
                                        <button class="btn btn-primary" type="submit">
                                            <i data-feather="save" class="me-1"></i>
                                            <?php echo e(localize('Save Changes')); ?>

                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<!--pagination start-->
<div class="d-flex align-items-center justify-content-between px-4 pb-4">
    <span><?php echo e(localize('Showing')); ?>

        <?php echo e($paymentHistories->firstItem()); ?>-<?php echo e($paymentHistories->lastItem()); ?>

        <?php echo e(localize('of')); ?>

        <?php echo e($paymentHistories->total()); ?> <?php echo e(localize('results')); ?></span>
    <nav>
        <?php echo e($paymentHistories->appends(request()->input())->links()); ?>

    </nav>
</div>
<!--pagination end-->
<?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/backend/admin/affiliate/inc/paymentHistoryTable.blade.php ENDPATH**/ ?>