<?php if(isCustomerUserGroup()): ?>
    <?php echo $__env->make('common.customer-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php else: ?>
    <ul class="tt-side-nav">
        <li class="side-nav-item nav-item">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon">
                    <span data-feather="home" class="icon-14"></span>
                </span>
                <span class="tt-nav-link-text"><?php echo e(localize('Dashboard')); ?></span>
            </a>
        </li>
        <?php
            $documentsRoutes = ['admin.folders.index', 'admin.documents.index'];
        ?>
        <?php if(isMenuGroupShow($documentsRoutes)): ?>
            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('Manage Documents')); ?></span>
            </li>
            <?php if(isRouteExists('admin.folders.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.folders.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="folder-plus" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"> <?php echo e(localize('Folders')); ?> </span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if(isRouteExists('admin.documents.index')): ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['admin.documents.index', 'admin.generated-content.show'], 'tt-menu-item-active')); ?>">
                    <a href="<?php echo e(route('admin.documents.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="file-text" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"> <?php echo e(localize('Documents')); ?> </span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>
        
        <li class="side-nav-item nav-item">
            <a data-bs-toggle="collapse" href="#chatZone" aria-expanded="false"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon">
                    <span data-feather="message-square" class="icon-14"></span>
                </span>
                <span class="tt-nav-link-text"><?php echo e(localize('Prompts Library')); ?></span>
            </a>
            <div class="collapse" id="chatZone">
                <ul class="side-nav-second-level">
                    <li>
                        <a href="<?php echo e(route('admin.prompt-groups.index')); ?>">
                            <?php echo e(localize('Prompt Group')); ?>

                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.prompts.index')); ?>">
                            <?php echo e(localize('Prompts')); ?>

                        </a>
                    </li>

                </ul>
            </div>
        </li>

        <?php
            $aiToolsRoutes = [
                'admin.ai-writer.create',
                'admin.ai-writer.index',
                'admin.images.index',
                'admin.text-to-speeches.index',
                'admin.voice-to-text.create',
                'admin.ai-plagiarism.index',
                'admin.ai-detector.index',
                'admin.videos.index',
                'admin.template-categories.index',
                'admin.templates.index',
                'admin.chat-categories.index',
                "admin.articles.edit"
            ];
        ?>

        <?php if(isMenuGroupShow($aiToolsRoutes)): ?>

            
            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('AI Blog Posts')); ?></span>
            </li>
            <?php
                $fullBlogRoutes = [
                    'admin.articles.create',
                    'admin.articles.index',
                    'admin.seo.articleSeoChecker',
                    'admin.articles.edit'
                ];
            ?>

            <?php if(isRouteExists('admin.articles.create')): ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($fullBlogRoutes, 'tt-menu-item-active')); ?>">
                    <a data-bs-toggle="collapse" href="#aiArticle" aria-expanded="<?php echo e(areActiveRoutes($fullBlogRoutes, 'true')); ?>"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon">
                            <span data-feather="refresh-ccw" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Blog Wizard')); ?></span>
                    </a>
                    <div class="collapse <?php echo e(areActiveRoutes($fullBlogRoutes, 'show')); ?>" id="aiArticle">
                        <ul class="side-nav-second-level">
                            <?php if(isRouteExists('admin.articles.create')): ?>
                                <li> <a href="<?php echo e(route('admin.articles.create')); ?>"><?php echo e(localize('Generate Blog Article')); ?></a></li>
                            <?php endif; ?>

                            <?php if(isRouteExists('admin.articles.index')): ?>
                                <li class="<?php echo e(areActiveRoutes(['admin.articles.edit', 'admin.articles.index', 'admin.seo.articleSeoChecker'], 'tt-menu-item-active blogWizard')); ?>">
                                    <a href="<?php echo e(route('admin.articles.index')); ?>" ><?php echo e(localize('Blog Article List')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>

            <?php
                $wpPostRoutes = [
                    'admin.wordpress.list',
                    'admin.seo.wpPostSeoChecker',
                    'admin.wordpress-credentials.index',
                    'admin.tags.index',
                    'admin.wordpress.authorLists',
                    'admin.blog-categories.index',
                    "admin.wordpress.articles.edit"
                ];
            ?>
            <?php if(isRouteExists('admin.articles.create')): ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($wpPostRoutes, 'tt-menu-item-active')); ?>">
                    <a data-bs-toggle="collapse" href="#wpPosts" aria-expanded="<?php echo e(areActiveRoutes($wpPostRoutes, 'true')); ?>"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon">
                            <span data-feather="list" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('WordPress Posts')); ?></span>
                    </a>
                    <div class="collapse <?php echo e(areActiveRoutes($wpPostRoutes, 'show')); ?>" id="wpPosts">
                        <ul class="side-nav-second-level">
                            <?php if(isRouteExists('admin.wordpress.list')): ?>
                                <li class="<?php echo e(areActiveRoutes(['admin.wordpress.list',"admin.wordpress.articles.edit", 'admin.seo.wpPostSeoChecker'], 'tt-menu-item-active wordpressImportedPosts')); ?>">
                                    <a href="<?php echo e(route('admin.wordpress.list')); ?>"><?php echo e(localize('WordPress Imported Posts')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.blog-categories.index')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.blog-categories.index')); ?>">
                                        <?php echo e('Wordpress Category'); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.tags.index')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.tags.index')); ?>">
                                        <?php echo e('Wordpress Tags'); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.wordpress.authorLists')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.wordpress.authorLists')); ?>">
                                        <?php echo e('Wordpress Author'); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.wordpress-credentials.index')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.wordpress-credentials.index')); ?>">
                                        <?php echo e('Wordpress Setting'); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>

            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('AI Chat')); ?></span>
            </li>
            <?php
                $aiRoutes = [
                    'admin.openai.chats.code-generator',
                    'admin.chats.aiImageChat',
                    'admin.chats.aiVisionChat',
                    'admin.chats.aiPDFChat',
                    'admin.chat-experts.index',
                    'admin.chats.index',
                ];
            ?>
            <?php if(isMenuGroupShow($aiRoutes)): ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($aiRoutes, 'tt-menu-item-active')); ?>">
                    <a data-bs-toggle="collapse" href="#sidebarAI" aria-expanded="<?php echo e(areActiveRoutes($aiRoutes, 'true')); ?>"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon">
                            <span data-feather="message-circle" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Chats')); ?></span>
                    </a>
                    <div class="collapse <?php echo e(areActiveRoutes($aiRoutes, 'show')); ?>" id="sidebarAI">
                        <ul class="side-nav-second-level">
                            <?php if(isRouteExists('admin.chat-experts.index')): ?>
                                <li class="<?php echo e(areActiveRoutes(['admin.chats.index'], 'tt-menu-item-active')); ?>">
                                    <a href="<?php echo e(getFirstActiveChatExpertId() != null ? route('admin.chats.index').'?chat_expert_id='.getFirstActiveChatExpertId() : route('admin.chats-expert.index')); ?>">
                                        <?php echo e(localize('AI Experts Chat')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.chats.aiImageChat')): ?>
                                <li> <a href="<?php echo e(route('admin.chats.aiImageChat')); ?>"><?php echo e(__('AI Image Chat')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.chats.aiVisionChat')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.chats.aiVisionChat')); ?>"><?php echo e(localize('AI Vision')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.chats.aiPDFChat')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.chats.aiPDFChat')); ?>"><?php echo e(localize('AI PDF Chat')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.openai.chats.code-generator')): ?>
                                <li> <a href="<?php echo e(route('admin.openai.chats.code-generator')); ?>"><?php echo e(localize('AI Code Generate')); ?></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>
            
            
        
            <?php
                $platformRoutes = ['admin.platforms.index','admin.accounts.index'];
            ?>
            <?php if(isMenuGroupShow($platformRoutes)): ?>
                <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                    <span class="tt-nav-title-text"><?php echo e(localize('Manage Accounts')); ?></span>
                </li>
                
                <?php if(isRouteExists('admin.platforms.index')): ?>
                    <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['admin.platforms.index'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('admin.platforms.index')); ?>" class="side-nav-link">
                            <span class="tt-nav-link-icon">
                                <span data-feather="command" class="icon-14"></span>
                            </span>
                            <span class="tt-nav-link-text"> <?php echo e(localize('Platforms')); ?> </span>
                        </a>
                    </li>
                <?php endif; ?>
                
                <?php if(isRouteExists('admin.accounts.index')): ?>
                    <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['admin.accounts.index'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('admin.accounts.index')); ?>?type=<?php echo e(getFirstActivePlatformSlug()); ?>" class="side-nav-link">
                            <span class="tt-nav-link-icon">
                                <span data-feather="target" class="icon-14"></span>
                            </span>
                            <span class="tt-nav-link-text"> <?php echo e(localize('Accounts')); ?> </span>
                        </a>
                    </li>
                <?php endif; ?>
            <?php endif; ?>

            
            <?php
                $postRoutes = ['admin.quick-texts.index','admin.prompt-groups.index', 'admin.prompts.index', 'admin.socials.posts.create', 'admin.socials.posts.index'];
            ?>
            <?php if(isMenuGroupShow($postRoutes)): ?>
                <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                    <span class="tt-nav-title-text"><?php echo e(localize('Social Posts')); ?></span>
                </li>
                
                
                <li class="side-nav-item nav-item">
                    <a data-bs-toggle="collapse" href="#posts" aria-expanded="false"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon">
                            <span data-feather="send" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('Posts')); ?></span>
                    </a>
                    <div class="collapse" id="posts">
                        <ul class="side-nav-second-level">
                            <li>
                                <a href="<?php echo e(route('admin.socials.posts.create')); ?>">
                                    <?php echo e(localize('Create Post')); ?>

                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('admin.socials.posts.index')); ?>">
                                    <?php echo e(localize('List Posts')); ?>

                                </a>
                            </li>
                        </ul>
                    </div>
                </li> 

                
                <?php if(isRouteExists('admin.quick-texts.index')): ?>
                    <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['admin.quick-texts.index'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('admin.quick-texts.index')); ?>" class="side-nav-link">
                            <span class="tt-nav-link-icon">
                                <span data-feather="file-text" class="icon-14"></span>
                            </span>
                            <span class="tt-nav-link-text"> <?php echo e(localize('Quick Texts')); ?> </span>
                        </a>
                    </li>
                <?php endif; ?>
            <?php endif; ?>
        
            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('AI Contents')); ?></span>
            </li>
            <?php
                $templateRoutes = ['admin.template-categories.index', 'admin.templates.index', 'admin.templates.show'];
            ?>

            <?php if(isMenuGroupShow($templateRoutes)): ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($templateRoutes, 'tt-menu-item-active')); ?>">
                    <a data-bs-toggle="collapse" href="#templates" aria-expanded="<?php echo e(areActiveRoutes($templateRoutes, 'true')); ?>"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon">
                            <span data-feather="file" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"> <?php echo e(localize('Templates')); ?></span>
                    </a>
                    <div class="collapse <?php echo e(areActiveRoutes($templateRoutes, 'show')); ?>" id="templates">
                        <ul class="side-nav-second-level">
                            <?php if(isRouteExists('admin.template-categories.index')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.template-categories.index')); ?>">
                                        <?php echo e(localize('Template Categories')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if(isRouteExists('admin.templates.index')): ?>
                                <li class="<?php echo e(areActiveRoutes(['admin.templates.show'], 'tt-menu-item-active')); ?>">
                                    <a href="<?php echo e(route('admin.templates.index')); ?>">
                                        <?php echo e(localize('Templates')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>

            <?php if(isRouteExists('admin.ai-writer.create') || isRouteExists('admin.ai-writer.index')): ?>
                <li class="side-nav-item nav-item">
                    <a data-bs-toggle="collapse" href="#aiWriter" aria-expanded="false"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon">
                            <span data-feather="pen-tool" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Writer')); ?></span>

                    </a>
                    <div class="collapse" id="aiWriter">
                        <ul class="side-nav-second-level">
                            <?php if(isRouteExists('admin.ai-writer.create')): ?>
                                <li> <a href="<?php echo e(route('admin.ai-writer.create')); ?>">
                                        <?php echo e(localize('AI Writer')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.ai-writer.index')): ?>
                                <li> <a href="<?php echo e(route('admin.ai-writer.index')); ?>">
                                        <?php echo e(localize('AI Writer List')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>

            <?php if(isRouteExists('admin.ai-rewriter.create') || isRouteExists('admin.ai-rewriter.index')): ?>
                <li class="side-nav-item nav-item">
                    <a data-bs-toggle="collapse" href="#aiReWriter" aria-expanded="false"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon">
                            <span data-feather="repeat" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Re-Writer')); ?></span>
                    </a>

                    <div class="collapse" id="aiReWriter">
                        <ul class="side-nav-second-level">
                            <?php if(isRouteExists('admin.ai-rewriter.index')): ?>
                                <li> <a href="<?php echo e(route('admin.ai-rewriter.index')); ?>">
                                        <?php echo e(localize('Re-Writer Content List')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.ai-rewriter.create')): ?>
                                <li> <a href="<?php echo e(route('admin.ai-rewriter.create')); ?>">
                                        <?php echo e(localize('Re-Writer Content')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>
            
            <?php if(isRouteExists('admin.ai-plagiarism.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.ai-plagiarism.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="file-minus" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"> <?php echo e(localize('AI Plagiarism')); ?> </span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if(isRouteExists('admin.ai-detector.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.ai-detector.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="type" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"> <?php echo e(localize('AI Detector')); ?> </span>
                    </a>
                </li>
            <?php endif; ?>

            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('AI Images')); ?></span>
            </li>
            <?php if(isRouteExists('admin.images.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.images.index')); ?>"
                        class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="image" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Images')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
            

            <?php if(isRouteExists('admin.images.photoStudio.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.images.photoStudio.index')); ?>"
                        class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="feather" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Photo Studio')); ?></span>
                    </a>
                </li>
            <?php endif; ?>

            
            <?php if(isRouteExists('admin.images.productShot.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.images.productShot.index')); ?>"
                        class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="camera" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Product Shot')); ?></span>
                    </a>
                </li>
            <?php endif; ?>

            
            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('AI Videos')); ?></span>
            </li>

            <?php
                $videoRoutes = ['admin.videos.index'];
            ?>

            <?php if(isMenuGroupShow($videoRoutes)): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.videos.index')); ?>"
                        class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="play" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Videos')); ?></span>
                    </a>
                </li>
                
            <?php endif; ?>

            <?php
                $aiAvatarRoutes = [
                  "admin.avatarPro.index"
                ];
            ?>
            <?php if(isMenuGroupShow($aiAvatarRoutes)): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.avatarPro.index')); ?>"
                        class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="film" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Avatar Pro')); ?></span>
                    </a>
                </li>
                
            <?php endif; ?>

            <?php
                $aiAvatarRoutes = [
                  "admin.brand-voices.create",
                  "admin.brand-voices.index",
                  "admin.brand-voices.edit",
                ];
            ?>
            <?php if(isMenuGroupShow($aiAvatarRoutes)): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.brand-voices.index')); ?>"
                        class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="rss" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('Brand Voice')); ?></span>
                    </a>


                </li>
                
            <?php endif; ?>

            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('AI Voices')); ?></span>
            </li>
            <?php if(isRouteExists('admin.voice-to-text.create')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.voice-to-text.create')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="mic" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"> <?php echo e(localize('Audio To Text')); ?> </span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if(isRouteExists('admin.text-to-speeches.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.text-to-speeches.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="volume-2" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text">
                            <?php echo e(localize('Text To Speech')); ?>

                        </span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if(isRouteExists('admin.voice.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.voice.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="copy" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"> <?php echo e(localize('AI Voice Clone')); ?> </span>
                    </a>
                </li>
            <?php endif; ?>
            
        <?php endif; ?>

        <?php
            $articleEditRoutes = currentRoute() == 'admin.articles.edit' ? 'admin.articles.edit?blogWizard' : "admin.articles.edit";

            $subscriptionRoutes = [
                'admin.subscription-plans.index',
                'admin.plan-histories.index',
                'admin.subscription-settings.index',
                'admin.plan-histories.show'
            ];

            $subscriptionHistoryRoutes = [
            'admin.plan-histories.index',
            'admin.plan-histories.show',
        ];
        ?>
        <?php if(isMenuGroupShow($subscriptionRoutes)): ?>
            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10 <?php echo e(areActiveRoutes($subscriptionRoutes, 'tt-menu-item-active')); ?>">
                <span class="tt-nav-title-text"><?php echo e(localize('Manage Subscriptions')); ?></span>
            </li>
            <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($subscriptionRoutes, 'tt-menu-item-active')); ?>">
                <a data-bs-toggle="collapse" href="#subscriptions" aria-expanded="false"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="zap" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Subscriptions')); ?></span>

                </a>
                <div class="collapse <?php echo e(areActiveRoutes($subscriptionRoutes, 'show')); ?>" id="subscriptions">
                    <ul class="side-nav-second-level">
                        <?php if(isRouteExists('admin.subscription-plans.index')): ?>
                            <li> <a
                                    href="<?php echo e(route('admin.subscription-plans.index')); ?>"><?php echo e(localize('Subscription Plan')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.plan-histories.index')): ?>
                            <li  class="<?php echo e(areActiveRoutes($subscriptionHistoryRoutes, 'tt-menu-item-active')); ?>"> <a
                                    href="<?php echo e(route('admin.plan-histories.index')); ?>"><?php echo e(localize('Subscription History')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.subscription-settings.index')): ?>
                            <li> <a
                                    href="<?php echo e(route('admin.subscription-settings.index')); ?>"><?php echo e(localize('Recurring Product Plan')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
        <?php endif; ?>

        <?php if(getSetting('enable_affiliate_system') == '1'): ?>
            <?php
                $affiliateRoutes = [
                    'admin.affiliate.withdraw.index',
                    'admin.affiliate.earnings.index',
                    'admin.affiliate.payments.index',
                ];
            ?>
            <?php if(isMenuGroupShow($subscriptionRoutes)): ?>
                <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                    <span class="tt-nav-title-text"><?php echo e(localize('Manage Affiliate')); ?></span>
                </li>
                <li class="side-nav-item nav-item">
                    <a data-bs-toggle="collapse" href="#affiliate" aria-expanded="false"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon">
                            <span data-feather="percent" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('Affiliate System')); ?></span>

                    </a>
                    <div class="collapse" id="affiliate">
                        <ul class="side-nav-second-level">
                            <?php if(isRouteExists('admin.affiliate.withdraw.index')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.affiliate.withdraw.index')); ?>"><?php echo e(localize('Withdraw Requests')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.affiliate.earnings.index')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.affiliate.earnings.index')); ?>"><?php echo e(localize('Earning Histories')); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if(isRouteExists('admin.affiliate.payments.index')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.affiliate.payments.index')); ?>"><?php echo e(localize('Payment Histories')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>
        <?php endif; ?>

        <!-- Report -->
        <?php
            $reportRoutes = [
                'admin.reports.words',
                'admin.reports.codes',
                'admin.reports.images',
                'admin.reports.s2t',
                'admin.reports.mostUsed',
                'admin.reports.subscriptions',
            ];
        ?>
        <?php if(isMenuGroupShow($reportRoutes)): ?>
            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('Reports')); ?></span>
            </li>
            <!-- Report -->
            <li class="side-nav-item nav-item ">
                <a data-bs-toggle="collapse" href="#reports" aria-expanded="false"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon"><i data-feather="bar-chart" class="icon-14"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Reports')); ?></span>
                </a>
                <div class="collapse" id="reports">
                    <ul class="side-nav-second-level">
                        <?php if(isRouteExists('admin.reports.words')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.reports.words')); ?>"><?php echo e(localize('Words Report')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.reports.codes')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.reports.codes')); ?>"><?php echo e(localize('Codes Report')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.reports.images')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.reports.images')); ?>"><?php echo e(localize('Images Report')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.reports.s2t')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.reports.s2t')); ?>"><?php echo e(localize('Speech to Texts')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.reports.mostUsed')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.reports.mostUsed')); ?>"><?php echo e(localize('Most Used Templates')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.reports.subscriptions')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.reports.subscriptions')); ?>"><?php echo e(localize('Subscriptions Reports')); ?></a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </div>
            </li>
        <?php endif; ?>

        <?php
            $supportoutes = [
                'admin.support-categories.index',
                'admin.support-priorities.index',
                'admin.support-tickets.index',
                'admin.support-tickets.reply'
            ];
        ?>

        <?php if(isMenuGroupShow($supportoutes)): ?>
            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('Support')); ?></span>
            </li>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#supportTicketManagement" aria-expanded="false"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="headphones" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Support Ticket')); ?></span>
                </a>
                <div class="collapse" id="supportTicketManagement">
                    <ul class="side-nav-second-level">
                        <?php if(isRouteExists('admin.support-categories.index')): ?>
                            <li> <a href="<?php echo e(route('admin.support-categories.index')); ?>"><?php echo e(localize('Category')); ?></a> </li>
                        <?php endif; ?>

                        <?php if(isRouteExists('admin.support-priorities.index')): ?>
                            <li> <a href="<?php echo e(route('admin.support-priorities.index')); ?>"><?php echo e(localize('priority')); ?></a></li>
                        <?php endif; ?>

                        <?php if(isRouteExists('admin.support-tickets.index')): ?>
                            <li> <a href="<?php echo e(route('admin.support-tickets.index')); ?>"><?php echo e(localize('Tickets')); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <li class="side-nav-item nav-item">
                <a href="<?php echo e(route('admin.queries.index')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon">
                        <span data-feather="help-circle" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"> <?php echo e(localize('Queries')); ?> </span>
                </a>
            </li>
        <?php endif; ?>

        <?php
            $contentRoutes = [
                'admin.tags.index',
                'admin.blogs.index',
                'admin.blog-categories.index',
                'admin.faqs.index',
                'admin.media-managers.index',
                'admin.support-categories.index',
                'admin.support-priorities.index',
                'admin.support-tickets.index',
               
            ];
        ?>
        <?php if(isMenuGroupShow($contentRoutes)): ?>

            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('Manage Contents')); ?></span>
            </li>
            <?php
                $userBlogManagementRoutes = ['admin.blogs.index', 'admin.blog-categories.index'];
            ?>
            <?php if(isMenuGroupShow($userBlogManagementRoutes)): ?>

                <li class="side-nav-item nav-item">
                    <a data-bs-toggle="collapse" href="#userBlogManagement" aria-expanded="false"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon">
                            <span data-feather="file-text" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('Website Blogs')); ?></span>
                    </a>
                    <div class="collapse" id="userBlogManagement">
                        <ul class="side-nav-second-level">
                            <?php if(isRouteExists('admin.blogs.index')): ?>
                                <li> <a href="<?php echo e(route('admin.blogs.index')); ?>"><?php echo e(localize('Blog List')); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if(isRouteExists('admin.blog-categories.index')): ?>
                                <li> <a href="<?php echo e(route('admin.blog-categories.index')); ?>"><?php echo e(localize('Blog Categories')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>
            <?php if(isRouteExists('admin.tags.index')): ?>
            <li class="side-nav-item nav-item">
                <a href="<?php echo e(route('admin.tags.index')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon">
                        <span data-feather="tag" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"> <?php echo e(localize('Tags')); ?> </span>
                </a>
            </li>
        <?php endif; ?>

            <?php if(isRouteExists('admin.pages.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.pages.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="file-plus" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"> <?php echo e(localize('Pages')); ?> </span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if(isRouteExists('admin.faqs.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.faqs.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="info" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"> <?php echo e(localize('All FAQs')); ?> </span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if(isRouteExists('admin.media-managers.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.media-managers.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="folder" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"> <?php echo e(localize('Media Manager')); ?> </span>
                    </a>
                </li>
            <?php endif; ?>
            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('Manage Promotions')); ?></span>
            </li>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#newsLetterManagement" aria-expanded="false"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="book-open" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Newsletters')); ?></span>
                </a>
                <div class="collapse" id="newsLetterManagement">
                    <ul class="side-nav-second-level">
                        <?php if(isRouteExists('admin.newsletters.index')): ?>
                            <li> <a href="<?php echo e(route('admin.newsletters.index')); ?>"><?php echo e(localize('Bulk Emails')); ?></a> </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.subscribers.index')): ?>
                            <li> <a href="<?php echo e(route('admin.subscribers.index')); ?>"><?php echo e(localize('Subscribers')); ?></a> </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            
        <?php endif; ?>
        <?php
            $userManagementRoutes = ['admin.customers.index', 'admin.users.index'];
        ?>
        <?php if(isMenuGroupShow($userManagementRoutes)): ?>
            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('User Management')); ?></span>
            </li>
            <?php if(isRouteExists('admin.customers.index')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('admin.customers.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon">
                            <span data-feather="users" class="icon-14"></span>
                        </span>
                        <span class="tt-nav-link-text"><?php echo e(localize('Customers')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>
        <?php
            $roleManagements = ['admin.users.index', 'admin.roles.index'];
        ?>
        <?php if(isMenuGroupShow($roleManagements)): ?>

            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#userROleManagement" aria-expanded="false"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="user-check" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Admins & Teams')); ?></span>
                </a>
                <div class="collapse" id="userROleManagement">
                    <ul class="side-nav-second-level">
                        <?php if(isRouteExists('admin.users.index')): ?>
                            <li> <a href="<?php echo e(route('admin.users.index')); ?>"><?php echo e(localize('Admins & Team')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.roles.index')): ?>
                            <li> <a href="<?php echo e(route('admin.roles.index')); ?>"><?php echo e(localize('Manage Roles')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
        <?php endif; ?>
        <?php
            $settingsRoutes = [
                'admin.settings.index',
                'admin.settings.credentials',
                'admin.email-templates.index',
                'admin.settings.adSense.index',
                'admin.languages.index',
                'admin.currencies.index',
                'admin.payment-gateways.index',
                'admin.offline-payment-methods.index',
                'admin.cron-list',
                'admin.pwa-settings.index',
                'admin.systemUpdate.health-check',
                'admin.systemUpdate.update',
            ];
        ?>
        <?php if(isMenuGroupShow($settingsRoutes)): ?>
            <li class="side-nav-title side-nav-item nav-item mt-4 fs-10">
                <span class="tt-nav-title-text"><?php echo e(localize('MANAGE SETTINGS')); ?></span>
            </li>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#sidebarSettingsMenu" aria-expanded="false"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="settings" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Settings')); ?></span>
                </a>
                <div class="collapse" id="sidebarSettingsMenu">
                    <ul class="side-nav-second-level">
                        <?php if(isRouteExists('admin.settings.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.settings.index')); ?>">
                                    <?php echo e('Features Settings'); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.settings.credentials')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.settings.credentials')); ?>">
                                    <?php echo e(localize('All Credentials Setup')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.wordpress-settings.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.wordpress-settings.index')); ?>">
                                    <?php echo e('Wordpress Settings'); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.pwa-settings.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.pwa-settings.index')); ?>">
                                    <?php echo e('PWA Setting'); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.email-templates.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.email-templates.index')); ?>">
                                    <?php echo e(localize('Email Template')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.settings.adSense.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.settings.adSense.index')); ?>">
                                    <?php echo e(localize('Google Ads')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.languages.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.languages.index')); ?>">
                                    <?php echo e(localize('Multi Language')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.currencies.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.currencies.index')); ?>">
                                    <?php echo e(localize('Multi Currency')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.payment-gateways.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.payment-gateways.index')); ?>">
                                    <?php echo e(localize('Payment Gateway')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.offline-payment-methods.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.offline-payment-methods.index')); ?>">
                                    <?php echo e(localize('Offline Payment')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.cron-list')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.cron-list')); ?>">
                                    <?php echo e(localize('Cron List')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.utilities')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.utilities')); ?>">
                                    <?php echo e(localize('Utilities')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
        <?php endif; ?>
        <?php
            $appearanceRoutes = ['admin.appearance.index', 'admin.client-feedbacks.index'];
        ?>
        <?php if(isMenuGroupShow($appearanceRoutes)): ?>
            <li class="side-nav-item nav-item">
                <a data-bs-toggle="collapse" href="#sidebarAppearance" aria-expanded="false"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon">
                        <span data-feather="eye" class="icon-14"></span>
                    </span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Appearance')); ?></span>
                </a>
                <div class="collapse" id="sidebarAppearance">
                    <ul class="side-nav-second-level">
                        <?php if(isRouteExists('admin.appearance.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.appearance.index')); ?>">
                                    <?php echo e('Appearance'); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.client-feedbacks.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.client-feedbacks.index')); ?>">
                                    <?php echo e('Client Feedback'); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.about-us.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.about-us.index')); ?>">
                                    <?php echo e('About Us'); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.privacy-policy.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.privacy-policy.index')); ?>">
                                    <?php echo e('Privacy Policy'); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(isRouteExists('admin.terms-conditions.index')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.terms-conditions.index')); ?>">
                                    <?php echo e('Terms Conditions'); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
        <?php endif; ?>
    </ul>
<?php endif; ?>

<?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/common/sidebar-ul.blade.php ENDPATH**/ ?>