<aside class="tt-sidebar bg-info <?php echo e(isSideBarCollapsed()); ?>" id="sidebar">
    <div class="tt-brand">
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="tt-brand-link">
            <img src="<?php echo e(getSetting('collapse_able_icon') ? avatarImage(getSetting('collapse_able_icon')) : asset('assets')); ?>/img/logo-icon.png" class="tt-brand-favicon d-none" width="44"
                alt="favicon" />
            <img src="<?php echo e(getSetting('logo_for_light') ? avatarImage(getSetting('logo_for_light')) : asset('assets')); ?>/img/logo.png" class="tt-brand-logo ms-2" alt="logo" width="164" />
        </a>
        <a href="javascript:void(0);" class="tt-toggle-sidebar">
            <span><i data-feather="chevron-left"></i></span>
        </a>
    </div>

    <div class="tt-sidebar-nav pb-9 pt-3 d-flex flex-column h-100 justify-content-between tt-custom-scrollbar">
        <nav class="navbar navbar-vertical navbar-expand-lg">
            <div class="collapse navbar-collapse" id="navbarVerticalCollapse">
                <div class="w-100" id="leftside-menu-container">
                   <?php echo $__env->make('common.sidebar-ul', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </nav>
        <ul class="tt-side-nav m-3 tt-user-side-nav">


            <!-- customer profile with affiliate link button -->
            <?php if(isCustomerUserGroup()): ?>
          
                <li class="side-nav-item nav-item tt-sidebar-user rounded-3 bg-secondary-subtle">
                    <div class="side-nav-link flex-column justify-content-center py-4">
                        <div class="tt-user-avatar lh-1 mb-2">
                            <div class="avatar avatar-md status-online">
                                <img class="rounded-circle" src="<?php echo e(avatarImage(user()->avatar)); ?>" alt=""
                                    onerror="this.onerror=null;this.src='<?php echo e(avatarImage(user()->avatar)); ?>';">
                            </div>
                        </div>
                        <div class="tt-nav-link-text text-center">
                            <h6 class="mb-0 lh-1 d-block"><?php echo e(user()->name); ?></h6>
                            <span class="text-muted fs-sm"> <?php echo html_entity_decode(optional(user()->plan)->title); ?>/<?php echo e(ucfirst(optional(user()->plan)->package_type)); ?></span>

                            <?php if(getSetting('enable_affiliate_system') == '1'): ?>
                                <div class="mt-3">
                                    <p class="text-muted fs-md">
                                        💰 <?php echo e(localize('Invite your friends and earn money from their subscriptions')); ?>

                                    </p>
                                    <a href="<?php echo e(route('admin.affiliate.overview')); ?>"
                                        class="btn btn-accent btn-sm rounded-pill shadow-sm"><?php echo e(localize('Invite Friends')); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </li>
            <?php else: ?>
                <!-- logout button for admin -->
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('logout')); ?>"
                        class="side-nav-link justify-content-center btn border border-primary rounded-pill text-center">
                        <?php echo e(localize('Logout')); ?> <i data-feather="log-out" class="icon-14 ms-2"></i>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </div>
</aside>
<?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/common/sidebar.blade.php ENDPATH**/ ?>