<?php $__env->startSection('title'); ?>
    <?php echo e(localize('Affiliate Configurations')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="tt-section pt-4">
        <div class="container">

            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header">
                        <div class="d-lg-flex align-items-center justify-content-lg-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('Affiliate Program')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('dashboard')); ?>"><?php echo e(localize('Dashboard')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><?php echo e(localize('Affiliate')); ?></li>
                                </ol>
                            </div>
                            <div class="tt-action">
                                <a href="javascript::void(0);" class="btn btn-soft-primary" data-bs-toggle="modal"
                                    data-bs-target="#withdraw-modal"><i data-feather="credit-card"></i>
                                    <?php echo e(localize('Withdraw Balance')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            
            <div class="row g-3 mb-4">
                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-2 flex-shrink-0">
                                    <div class="text-center rounded bg-soft-warning">
                                        <span><i data-feather="dollar-sign"></i></span>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <p class="mb-0"><?php echo e(localize('Available Balance')); ?></p>
                                    <h4 class="mb-0"><?php echo e(formatPrice($user->user_balance, true)); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-2 flex-shrink-0">
                                    <div class="text-center rounded bg-soft-primary">
                                        <span><i data-feather="credit-card"></i></span>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <p class="mb-0"><?php echo e(localize('Total Subscriptions')); ?></p>
                                    <h4 class="mb-0"><?php echo e($user->referredUserEarnings()->count()); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-2 flex-shrink-0">
                                    <div class="text-center rounded bg-soft-danger">
                                        <span><i data-feather="link"></i></span>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <p class="mb-0"><?php echo e(localize('Total Clicks')); ?></p>
                                    <h4 class="mb-0"><?php echo e($user->num_of_clicks); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="avatar me-2 flex-shrink-0">
                                    <div class="text-center rounded bg-soft-info">
                                        <span><i data-feather="users"></i></span>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <p class="mb-0"><?php echo e(localize('Referral Signups')); ?></p>
                                    <h4 class="mb-0"><?php echo e($user->referredUsers()->count()); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            


            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-xl-6">
                                    <h5><?php echo e(localize('How to use Referral Program')); ?></h5>
                                    <p>
                                        <?php echo e(localize('Our affiliate program commission rate for subscriptions is')); ?>:
                                        <strong><?php echo e(getSetting('affiliate_commission')); ?>%</strong>
                                    </p>
                                    <ul class="list-unstyled">
                                        <li><i data-feather="check-circle" class="me-2 text-success icon-16"></i>
                                            <?php echo e(localize('1. Copy referral link')); ?></li>
                                        <li><i data-feather="check-circle" class="me-2 text-success icon-16"></i>
                                            <?php echo e(localize('2. Share with your friends & others')); ?></li>
                                        <li><i data-feather="check-circle" class="me-2 text-success icon-16"></i>
                                            <?php echo e(localize('3. Make money on their subscriptions')); ?></li>
                                    </ul>
                                </div>

                                <div class="col-xl-6">
                                    <h5 class="text-gray-800">
                                        <?php echo e(localize('Your Referral Link')); ?>

                                    </h5>

                                    <p>
                                        <?php echo e(localize('Invite your friends & others and earn commissions from their subscriptions')); ?>.
                                    </p>

                                    <div class="d-flex">
                                        <textarea type="text" class="form-control me-3 flex-grow-1" rows="1" id="referral_code_url" readonly><?php echo e(route('register')); ?>?referral_code=<?php echo e($user->referral_code); ?></textarea>
                                        <button class="btn btn-soft-warning" id="ref-cpurl-btn"
                                            data-attrcpy="<?php echo e(localize('Copied')); ?>"
                                            onclick="copyToClipboard()"><?php echo e(localize('Copy Link')); ?>

                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header py-3">
                            <h3 class="h5 mb-0"><?php echo e(localize('Recent Affiliate Earnings')); ?></h3>
                        </div>
                        <div class="card-body p-0">
                            
                              <?php echo $__env->make('backend.admin.affiliate.inc.earningHistoryTable', [
                                'earningHistories' => $earningHistories,
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div id="withdraw-modal" class="modal fade modalParentSelect2">
        <div class="modal-dialog modal-md modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(localize('Withdraw Money')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                </div>
                <div class="modal-body">
                    <?php
                        $payoutAccounts = user()->affiliatePayoutAccounts;
                        $activeAffiliatePaymentMethods = getSetting('affiliate_payout_payment_methods') != null ? json_decode(getSetting('affiliate_payout_payment_methods')) : [];
                    ?>

                    <form action="<?php echo e(route('admin.affiliate.withdraw.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="amount" class="form-label">
                                <?php echo e(localize('Withdrawal Amount')); ?>

                                <span class="text-danger">*</span>
                            </label>

                            <?php if (isset($component)) { $__componentOriginal5c2a97ab476b69c1189ee85d1a95204b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c2a97ab476b69c1189ee85d1a95204b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.input','data' => ['type' => 'number','id' => 'amount','name' => 'amount','class' => 'form-control','placeholder' => ''.e(localize('Type amount')).'','step' => '0.001','min' => ''.e(formatPrice(getSetting('minimum_withdrawal_amount'), false, false, false)).'','max' => ''.e(user()->user_balance).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'number','id' => 'amount','name' => 'amount','class' => 'form-control','placeholder' => ''.e(localize('Type amount')).'','step' => '0.001','min' => ''.e(formatPrice(getSetting('minimum_withdrawal_amount'), false, false, false)).'','max' => ''.e(user()->user_balance).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c2a97ab476b69c1189ee85d1a95204b)): ?>
<?php $attributes = $__attributesOriginal5c2a97ab476b69c1189ee85d1a95204b; ?>
<?php unset($__attributesOriginal5c2a97ab476b69c1189ee85d1a95204b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c2a97ab476b69c1189ee85d1a95204b)): ?>
<?php $component = $__componentOriginal5c2a97ab476b69c1189ee85d1a95204b; ?>
<?php unset($__componentOriginal5c2a97ab476b69c1189ee85d1a95204b); ?>
<?php endif; ?>

                            <small>*<?php echo e(localize('Minimum Withdrawal Amount: ')); ?> <?php echo e(formatPrice(getSetting('minimum_withdrawal_amount'))); ?></small>
                        </div>

                        <div class="mb-3">
                            <label for="payout_account_id" class="form-label">
                                <?php echo e(localize('Payout Account')); ?>

                                <small class="text-danger">*</small>
                            </label>
                            <?php if (isset($component)) { $__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.select','data' => ['class' => 'form-select modalSelect2','id' => 'payout_account_id','name' => 'payout_account_id']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'form-select modalSelect2','id' => 'payout_account_id','name' => 'payout_account_id']); ?>
                                <option value="">
                                    <?php echo e(localize('Select Payout Account')); ?>

                                </option>

                                <?php $__currentLoopData = $payoutAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payoutAccount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(in_array($payoutAccount->payment_method, $activeAffiliatePaymentMethods) && $payoutAccount->account_details != null): ?>
                                        <option value="<?php echo e($payoutAccount->id); ?>">
                                            <?php echo e(ucwords(str_replace('_', ' ', $payoutAccount->payment_method))); ?>

                                        </option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36)): ?>
<?php $attributes = $__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36; ?>
<?php unset($__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36)): ?>
<?php $component = $__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36; ?>
<?php unset($__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36); ?>
<?php endif; ?>
                        </div>

                        <div class="mb-3">
                            <label for="additional_info" class="form-label"><?php echo e(localize('Additional Info')); ?></label>
                            <textarea id="additional_info" name="additional_info" class="form-control"
                                      placeholder="<?php echo e(localize('Type additional info')); ?>"></textarea>
                        </div>


                        <div class="mb-3">
                            <button class="btn btn-primary" type="submit">
                                <i data-feather="save" class="me-1"></i>
                                <?php echo e(localize('Submit Request')); ?>

                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>





<?php $__env->startSection('js'); ?>
    <?php if($errors->any()): ?>
        <script>
            $(()=>{
                $('#withdraw-modal').modal('show');
            });
        </script>
    <?php endif; ?>

    <script>
        "use strict";

        function copyToClipboard(btn) {
            var el_url = document.getElementById('referral_code_url');
            var c_u_b = document.getElementById('ref-cpurl-btn');
            if (el_url != null && c_u_b != null) {
                el_url.select();
                document.execCommand('copy');
                c_u_b.innerHTML = c_u_b.dataset.attrcpy;
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u191805559/domains/aitwl.com/public_html/resources/views/backend/admin/affiliate/overview.blade.php ENDPATH**/ ?>