<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class TemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = array(
            array('id' => '1','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Ai Article Generator','description' => 'End your blog posts on a high note. Craft memorable conclusions that leave a lasting impact.','slug' => 'ai-article-generator-v6D4U8r8y0s4h8M','icon' => NULL,'fields' => '[{"label":"Title of the blog","is_required":true,"field":{"name":"title","type":"text","slug":"title"}},{"label":"What are the main points you want to cover?","is_required":true,"field":{"name":"key_points","type":"textarea","slug":"key_points"}}]','prompt' => 'Write a complete article in english language on this topic {_title_} .Use following keywords in the article {_key_points_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'blog-section','template_category_id' => '1','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 05:50:19'),
            array('id' => '2','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Ai Product Description','description' => 'Engaging product descriptions highlight features, emphasize benefits, build trust, inspire purchases,','slug' => 'ai-product-description-A9M9Y2m6B2G8W8C','icon' => NULL,'fields' => '[{"label":"About what is your blog post?","is_required":true,"field":{"name":"about","type":"textarea","slug":"about"}}]','prompt' => 'Write interesting blog ideas in english language based on this text {_about_} .Generate 10 appropriate blog titles in english language based on this text {_about_} .Write an interesting blog post intro in english language based on this text {_about_}.Blog post title {_title_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'blog-ideas','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 05:53:00'),
            array('id' => '3','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Ai Blog Conclusion','description' => 'In summary, actionable insights drive success and inspire meaningful growth for all.','slug' => 'ai-blog-conclusion-r0t7h7p4K5i5w4q','icon' => NULL,'fields' => '[{"label":"About what is your blog post?","is_required":true,"field":{"name":"about","type":"textarea","slug":"about"}}]','prompt' => 'Generate 10 appropriate blog titles in english language based on this text {_about_} .Write an interesting blog post intro in english language based on this text {_about_}.Blog post title {_title_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'blog-title','template_category_id' => '1','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 05:56:14'),
            array('id' => '4','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Blog Intro','description' => 'Discover expert tips, innovative ideas, and strategies to enhance your success and productivity.','slug' => 'blog-intro-v3p8L6B7F3N9m3u','icon' => NULL,'fields' => '[{"label":"Title of the blog","is_required":true,"field":{"name":"title","type":"text","slug":"title"}},{"label":"About what is your blog post?","is_required":true,"field":{"name":"about","type":"textarea","slug":"about"}}]','prompt' => 'Write an interesting blog post intro in english language based on this text {_about_}.Blog post title {_title_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'blog-intro','template_category_id' => '1','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 05:57:28'),
            array('id' => '5','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Blog Conclusion','description' => 'Generate blog conclusion for your next post','slug' => 'blog-conclusion','icon' => NULL,'fields' => '[{"label": "Title of the blog","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "e.g. best restaurants in LA to eat indian foods"}},{"label": "About what is your blog post?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": ""}}]','prompt' => 'Write an interesting blog conclusion in english language based on this text {_about_}.Blog post title {_title_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'blog-conclusion','template_category_id' => '1','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 05:58:07'),
            array('id' => '6','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Blog Tags','description' => 'Use relevant blog tags to enhance discoverability, improve SEO, and attract the right audience.','slug' => 'blog-tags-g8q2g1k0z1O8y4X','icon' => NULL,'fields' => '[{"label":"About what is your blog post?","is_required":true,"field":{"name":"about","type":"textarea","slug":"about"}}]','prompt' => 'Write blog tags in english language based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'blog-tags','template_category_id' => '1','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 05:58:38'),
            array('id' => '7','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Blog Summary','description' => 'This blog provides essential tips, strategies, and insights to boost your personal growth.','slug' => 'blog-summary-O0k7Q4w2A9f2b1k','icon' => NULL,'fields' => '[{"label":"About what is your blog post?","is_required":true,"field":{"name":"about","type":"textarea","slug":"about"}}]','prompt' => 'Write blog summary in english language based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'blog-summary','template_category_id' => '1','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 05:59:15'),
            array('id' => '8','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Confirmation Email','description' => 'Thank you for your order! Your purchase has been confirmed and will ship soon.','slug' => 'confirmation-email-X5p6t7O9p9v2S1S','icon' => NULL,'fields' => '[{"label":"What is recipient name?","is_required":true,"field":{"name":"name","type":"text","slug":"name"}},{"label":"About what is your email?","is_required":true,"field":{"name":"about","type":"textarea","slug":"about"}}]','prompt' => 'Write a confirmation email in english language based on this text {_about_}. Recipient name {_name_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'confirmation-email','template_category_id' => '2','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 06:00:19'),
            array('id' => '9','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Discount Email','description' => 'Exclusive offer! Enjoy a special discount on your next purchase. Don’t miss out!','slug' => 'discount-email-e9l6J5E7f3K6a0b','icon' => NULL,'fields' => '[{"label":"About what is your email?","is_required":true,"field":{"name":"about","type":"textarea","slug":"about"}}]','prompt' => 'Write a discount email in english language based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'discount-email','template_category_id' => '2','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 06:01:07'),
            array('id' => '10','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Testimonial Email','description' => 'We value your feedback! Share your experience with us and help others make informed decisions.','slug' => 'testimonial-email-a5h0U3h8e4h3V6i','icon' => NULL,'fields' => '[{"label":"What is recipient name?","is_required":true,"field":{"name":"name","type":"text","slug":"name"}},{"label":"About what is your email?","is_required":true,"field":{"name":"about","type":"textarea","slug":"about"}}]','prompt' => 'Write a testimonial email in english language based on this text {_about_}. Recipient name {_name_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'testimonial-email','template_category_id' => '2','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 06:02:07'),
            array('id' => '11','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Promotional Email','description' => 'Unlock amazing deals! Shop now and save big on our latest products and offers','slug' => 'promotional-email-F5i1S8f6Q7h3o5a','icon' => NULL,'fields' => '[{"label":"What is recipient name?","is_required":true,"field":{"name":"name","type":"text","slug":"name"}},{"label":"About what is your email?","is_required":true,"field":{"name":"about","type":"textarea","slug":"about"}}]','prompt' => 'Write a promotional email in english language based on this text  {_about_} . Recipient name {_name_}.Write a follow up email in english language based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'promotional-email','template_category_id' => '2','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 06:02:47'),
            array('id' => '12','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Follow Up Email','description' => NULL,'slug' => 'follow-up-email','icon' => NULL,'fields' => '[{"label": "About what is your email?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "e.g. Following up after an interview"}}]','prompt' => 'Write a follow up email in english language based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'follow-up-email','template_category_id' => '2','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-27 06:02:33'),
            array('id' => '13','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Twitter Post','description' => NULL,'slug' => 'twitter-post','icon' => NULL,'fields' => '[{"label": "About what is your post?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "e.g. Going to watch the champions league final"}}]','prompt' => 'Write a tweet in english language to post in twitter based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'twitter-post','template_category_id' => '3','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '14','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Discount Promotion','description' => NULL,'slug' => 'discount-promotion','icon' => NULL,'fields' => '[{"label": "What is title for the promotion?","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "e.g. Get exclusive discounts on Eid occasion"}},{"label": "About what is the discount?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "e.g. Get discount on first purchase (of product name/from company name)"}}]','prompt' => 'Write a catchy promotional article in english language to give discount based on this text {_about_}. Title of the promotion is {_title_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'discount-promotion','template_category_id' => '3','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '15','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Social Media Bio','description' => NULL,'slug' => 'social-media-bio-z4S6V1s5o4v9R2P','icon' => NULL,'fields' => '[{"label":"What are the main points you want to cover?","is_required":true,"field":{"name":"key_points","type":"textarea","slug":"key_points"}}]','prompt' => 'Write bio in english language for social media using following keywords {_key_points_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'social-media-bio','template_category_id' => '3','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2025-01-06 12:42:38'),
            array('id' => '16','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Facebook Ads','description' => NULL,'slug' => 'facebook-ads','icon' => NULL,'fields' => '[{"label": "Who is your targetted audiences?","is_required": true,"field":{"name": "audience", "slug":"audience","type": "text","placeholder": "e.g. Children, Couple"}},{"label": "What is the name of the product?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": "e.g. iPhone 14 Pro"}},{"label": "Product Description","is_required": true,"field":{"name": "description", "slug":"description","type": "textarea","placeholder": "Type product description"}}]','prompt' => 'Write a Facebook Ads description in english language that makes your ad stand out and generates leads. Target audience {_audience_}. Product name {_name_} . Product description {_description_} .Write 10 captions in english language for instagram post based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'facebook-ads','template_category_id' => '3','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '17','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Instagram Captions','description' => NULL,'slug' => 'instagram-captions','icon' => NULL,'fields' => '[{"label": "About what is your instagram post?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "e.g. Travelling the world"}}]','prompt' => 'Write 10 captions in english language for instagram post based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'instagram-captions','template_category_id' => '3','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '18','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Social Media Post','description' => NULL,'slug' => 'social-media-post','icon' => NULL,'fields' => '[{"label": "About what is your post?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "e.g. Travelling the world"}}]','prompt' => 'Write a complete social media post in english language based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'social-media-post','template_category_id' => '3','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '19','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Event Promotion','description' => NULL,'slug' => 'event-promotion','icon' => NULL,'fields' => '[{"label": "Title of the event","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "e.g. Celebration of victory day"}},{"label": "About what is your event?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type short description about the event"}}]','prompt' => 'Write a catchy promotional article in english language for an event based on this text {_about_}. Event title {_title_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'event-promotion','template_category_id' => '3','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '20','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Google Ads Headlines','description' => NULL,'slug' => 'google-ads-headlines','icon' => NULL,'fields' => '[{"label": "Who is your targetted audience?","is_required": true,"field":{"name": "audience", "slug":"audience","type": "text","placeholder": "e.g. Children, Couple"}},{"label": "What is the name of the product?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": "e.g. iPhone 14 Pro"}},{"label": "Product Description","is_required": true,"field":{"name": "description", "slug":"description","type": "textarea","placeholder": "Type product description"}}]','prompt' => 'Write 10 catchy headlines in english language to promote your product with Google Ads. Target audience {_audience_}. Product name {_name_} .Product description {_description_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'google-ads-headlines','template_category_id' => '3','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '21','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Google Ads Description','description' => NULL,'slug' => 'google-ads-description','icon' => NULL,'fields' => '[{"label": "Who is your targetted audience?","is_required": true,"field":{"name": "audience", "slug":"audience","type": "text","placeholder": "e.g. Children, Couple"}},{"label": "What is the name of the product?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": "e.g. iPhone 14 Pro"}},{"label": "Product Description","is_required": true,"field":{"name": "description", "slug":"description","type": "textarea","placeholder": "Type product description"}}]','prompt' => 'Write a Google Ads description in english language that makes your ad stand out and generates leads. Target audience {_audience_}. Product name {_name_} .Product description {_description_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'google-ads-description','template_category_id' => '3','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '22','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Youtube Video Title','description' => NULL,'slug' => 'youtube-video-title','icon' => NULL,'fields' => '[{"label": "About what is the video?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the video"}}]','prompt' => 'Write compelling YouTube video title in english language for the provided video description to get people interested in watching {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'youtube-video-title','template_category_id' => '4','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '23','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Youtube Video Description','description' => NULL,'slug' => 'youtube-video-description','icon' => NULL,'fields' => '[{"label": "About what is the video?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the video"}}]','prompt' => 'Write compelling YouTube description in english language for the provided video description to get people interested in watching {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'youtube-video-description','template_category_id' => '4','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '24','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Youtube Video Tag Generator','description' => NULL,'slug' => 'youtube-video-tag-generator','icon' => NULL,'fields' => '[{"label": "About what is the video?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the video"}}]','prompt' => 'Generate SEO-optimized YouTube tags and keywords in english language based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'youtube-video-tag-generator','template_category_id' => '4','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '25','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Website FAQ','description' => NULL,'slug' => 'website-faq','icon' => NULL,'fields' => '[{"label": "About what is the FAQ?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": ""}}]','prompt' => 'Generate list of 10 frequently asked questions in english language based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'website-faq','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '26','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Website FAQ Answers','description' => NULL,'slug' => 'website-faq-answers','icon' => NULL,'fields' => '[{"label": "What is the question?","is_required": true,"field":{"name": "question","slug": "question","type": "text","placeholder": "e.g. Do we provide support for 24/7?"}}]','prompt' => 'Write answer in english language for this faq question {_question_}.Write review in english language to submit on a website based on this text {_description_}.Product  {_name_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'website-faq-answers','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '27','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Website Review','description' => NULL,'slug' => 'website-review','icon' => NULL,'fields' => '[{"label": "What is the name of the product?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": "e.g. iPhone 14 Pro"}},{"label": "Product Description","is_required": true,"field":{"name": "description", "slug":"description","type": "textarea","placeholder": "Type product description"}}]','prompt' => 'Write review in english language to submit on a website based on this text {_description_}.Product  {_name_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'website-review','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '28','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Website Title','description' => NULL,'slug' => 'website-title','icon' => NULL,'fields' => '[{"label": "About what is the website?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the website"}}]','prompt' => 'Write title in english language for a website based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'website-title','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '29','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Website Meta Tags','description' => NULL,'slug' => 'website-meta-tags','icon' => NULL,'fields' => '[{"label": "About what is the website?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the website"}}]','prompt' => 'Write meta keywords, meta title, meta description, meta author in english language for a website based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'website-meta-tags','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '30','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Website Meta Description','description' => NULL,'slug' => 'website-meta-description','icon' => NULL,'fields' => '[{"label": "About what is the website?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the website"}}]','prompt' => 'Write seo friendly meta description in english language for a website based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'website-meta-description','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '31','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Website About Us','description' => NULL,'slug' => 'website-about-us','icon' => NULL,'fields' => '[{"label": "About what is the website?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the website"}}]','prompt' => 'Generate about us content in english language for a website based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'website-about-us','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '32','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Website Terms And Conditions','description' => NULL,'slug' => 'website-terms-and-conditions','icon' => NULL,'fields' => '[{"label": "What is your website title?","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "Type title of the website"}}]','prompt' => 'Generate terms and conditions in english language for this website {_title_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'website-terms-and-conditions','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '33','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Website Privacy Policy','description' => NULL,'slug' => 'website-privacy-policy','icon' => NULL,'fields' => '[{"label": "What is your website title?","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "Type title of the website"}}]','prompt' => 'Generate privacy policy in english language for this website {_title_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'website-privacy-policy','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '34','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Vision of the Company','description' => NULL,'slug' => 'vision-of-the-company','icon' => NULL,'fields' => '[{"label": "What is your company name?","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "Type name of the company"}},{"label": "What is your company about?","is_required": true,"field":{"name": "about", "slug":"about","type": "text","placeholder": "Type about of the company"}}]','prompt' => 'Generate vision in english language for this company named: {_title_} Company details: {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'vision-of-the-company','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '35','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Mission of the Company','description' => NULL,'slug' => 'mission-of-the-company','icon' => NULL,'fields' => '[{"label": "What is your company name?","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "Type name of the company"}},{"label": "What is your company about?","is_required": true,"field":{"name": "about", "slug":"about","type": "text","placeholder": "Type about of the company"}}]','prompt' => 'Generate mission in english language for this company named:{_title_} Company details: {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'mission-of-the-company','template_category_id' => '5','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '36','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Academic Essay','description' => NULL,'slug' => 'academic-essay','icon' => NULL,'fields' => '[{"label": "Title of the essay","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "e.g. The Newspaper"}}]','prompt' => 'Write an academic essay in english language for the title or topic:{_title_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'academic-essay','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '37','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Article Generator','description' => NULL,'slug' => 'article-generator','icon' => NULL,'fields' => '[{"label": "Title of the article","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "e.g. best restaurants in LA to eat indian foods"}},{"label": "What are the main points you want to cover?","is_required": true,"field":{"name": "key_points","type": "textarea","placeholder": "e.g. dosa, biriyani, tandoori chicken"}}]','prompt' => 'Write a complete article in english language on this topic {_title_} .Use following keywords in the article {_key_points_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'article-generator','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '38','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Paragraph Generator','description' => NULL,'slug' => 'paragraph-generator','icon' => NULL,'fields' => '[{"label": "Title of the paragraph","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "e.g. best restaurants in LA to eat indian foods"}},{"label": "What are the main points you want to cover?","is_required": true,"field":{"name": "key_points","type": "textarea","placeholder": "e.g. dosa, biriyani, tandoori chicken"}}]','prompt' => 'Write paragraph in english language on this topic {_title_} .Use following keywords in the article {_key_points_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'paragraph-generator','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '39','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Content Rewriter','description' => NULL,'slug' => 'content-rewriter','icon' => NULL,'fields' => '[{"label": "What would you like to rewrite?","is_required": true,"field":{"name": "contents","slug":"contents","type": "textarea","placeholder": "Type your content here to rewrite"}},{"label": "What are the main points you want to cover?","is_required": true,"field":{"name": "key_points","type": "textarea","placeholder": "e.g. key point 1, key point 2"}}]','prompt' => 'Rewrite this content in english language {_contents_}. Focus on the following keywords while generating the content {_key_points_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'content-rewriter','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '40','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Product Description','description' => NULL,'slug' => 'product-description','icon' => NULL,'fields' => '[{"label": "What is the name of the product?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": "e.g. iPhone 14 Pro"}}]','prompt' => 'Write a long creative product description in english language for {_name_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'product-description','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '41','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Product Name Generator','description' => NULL,'slug' => 'product-name-generator','icon' => NULL,'fields' => '[{"label": "Product Description","is_required": true,"field":{"name": "description", "slug":"description","type": "textarea","placeholder": "Type product description"}}]','prompt' => 'Create creative product names in english language based on the description {_description_}.Summarize this text in english language in a short concise way {_description_}.Product name {_name_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'product-name-generator','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '42','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Product Summarize Text','description' => NULL,'slug' => 'product-summarize-text','icon' => NULL,'fields' => '[{"label": "What is the name of the product?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": "e.g. iPhone 14 Pro"}},{"label": "Product Description","is_required": true,"field":{"name": "description", "slug":"description","type": "textarea","placeholder": "Type product description"}}]','prompt' => 'Summarize this text in english language in a short concise way {_description_}.Product name {_name_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'product-summarize-text','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '43','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Grammar Checker','description' => NULL,'slug' => 'grammar-checker','icon' => NULL,'fields' => '[{"label": "Type content you would like to check grammar","is_required": true,"field":{"name": "contents","slug":"contents","type": "textarea","placeholder": "Type your content here to check grammar"}}]','prompt' => 'Check and correct grammar of this text {_contents_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'grammar-checker','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '44','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Creative Story','description' => NULL,'slug' => 'creative-story','icon' => NULL,'fields' => '[{"label": "About what is the story?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Generate an interesting creative story in english language based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'creative-story','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '45','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Startup Name Generator','description' => NULL,'slug' => 'startup-name-generator','icon' => NULL,'fields' => '[{"label": "Start Up Description","is_required": true,"field":{"name": "description", "slug":"description","type": "textarea","placeholder": "Type start up description"}}]','prompt' => 'Generate start up names in english language based on this text {_description_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'startup-name-generator','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '46','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Pros & Cons','description' => NULL,'slug' => 'pros-cons','icon' => NULL,'fields' => '[{"label": "What is the topic?","is_required": true,"field":{"name": "topic","type": "text","placeholder": "e.g. Using mobile phone"}}]','prompt' => 'Write pros and cons in english language of the topic {_topic_}.Write job description in english language based on the requirements {_requirements_}. Job position {_position_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'pros-cons','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:05','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '47','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Job Description','description' => NULL,'slug' => 'job-description','icon' => NULL,'fields' => '[{"label": "What is the job position?","is_required": true,"field":{"name": "position","type": "text","placeholder": "e.g. What is the position of the job?"}},{"label": "What are the core requirements?","is_required": true,"field":{"name": "requirements","type": "textarea","placeholder": "Type requirements for the position"}}]','prompt' => 'Write job description in english language based on the requirements {_requirements_}. Job position {_position_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'job-description','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-12-31 12:08:54'),
            array('id' => '48','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Rejection Letter','description' => NULL,'slug' => 'rejection-letter','icon' => NULL,'fields' => '[{"label": "What is recipient name?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": "e.g. Ryan Toland"}},{"label": "About what is the rejection letter?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "e.g. Rejection letter of the job application for the position of software engineer"}}]','prompt' => 'Write a rejection letter in english language based on this text {_about_} Recipient name {_name_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'rejection-letter','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '49','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Offer Letter','description' => NULL,'slug' => 'offer-letter','icon' => NULL,'fields' => '[{"label": "What is recipient name?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": "e.g. Ryan Toland"}},{"label": "About what is the offer letter?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "e.g. Offer letter of the job for the position of software engineer"}}]','prompt' => 'Write an offer letter in english language based on this text  {_about_} Recipient name {_name_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'offer-letter','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '50','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Promotion Letter','description' => NULL,'slug' => 'promotion-letter','icon' => NULL,'fields' => '[{"label": "What is recipient name?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": "e.g. Ryan Toland"}},{"label": "What was the previous position?","is_required": true,"field":{"name": "previous_position","slug": "previous-position","type": "text","placeholder": "e.g. Junior executive"}},{"label": "What is the new position?","is_required": true,"field":{"name": "new_position","slug": "new-position","type": "text","placeholder": "e.g. Executive"}}]','prompt' => 'Write a promotion letter in english language Recipient name {_name_} Previous position {_previous_position_} New position {_news_position_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'promotion-letter','template_category_id' => '6','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '51','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Motivational Quote','description' => NULL,'slug' => 'motivational-quote','icon' => NULL,'fields' => '[{"label": "About what you want to generate motivational quote?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "e.g. Emotional breakdown, economical breakdown, career issue"}}]','prompt' => 'Write inspiring motivational quotes in english language to overcome the given situations  {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'motivational-quote','template_category_id' => '7','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '52','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Song Lyrics','description' => NULL,'slug' => 'song-lyrics','icon' => NULL,'fields' => '[{"label": "Title of the song and name of the singer/writer","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": "e.g. 500 miles by Hedy West"}}]','prompt' => 'Write full song lyrics of {_title_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'song-lyrics','template_category_id' => '7','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '53','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Short Story','description' => NULL,'slug' => 'short-story','icon' => NULL,'fields' => '[{"label": "About what is the story?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Write a creative short story in english language based on this text {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'short-story','template_category_id' => '7','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '54','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Wedding Quote','description' => NULL,'slug' => 'wedding-quote','icon' => NULL,'fields' => '[{"label": "What are the key points?","is_required": true,"field":{"name": "key_points","type": "textarea","placeholder": "e.g. Love, Forever, Soulmate"}}]','prompt' => 'Write lovely wedding quotes in english language based on these keywords {_key_points_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'wedding-quote','template_category_id' => '7','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '55','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Birthday Wish Quote','description' => NULL,'slug' => 'birthday-wish-quote','icon' => NULL,'fields' => '[{"label": "What are the key points?","is_required": true,"field":{"name": "key_points","type": "textarea","placeholder": "e.g. Long live, happy"}}]','prompt' => 'Write birthday wish quotes in english language based on these keywords {_key_points_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'birthday-wish-quote','template_category_id' => '7','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '56','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Story Outline','description' => NULL,'slug' => 'story-outline','icon' => NULL,'fields' => '[{"label": "About what is the story?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Write the outline of the story in english language for medium.com based on this description {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'story-outline','template_category_id' => '8','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '57','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Story Title & Subtitle','description' => NULL,'slug' => 'story-title-subtitle','icon' => NULL,'fields' => '[{"label": "About what is the story?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Write the title & subtitle of the story in english language for medium.com based on this description  {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'story-title-subtitle','template_category_id' => '8','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '58','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Story Ideas','description' => NULL,'slug' => 'story-ideas','icon' => NULL,'fields' => '[{"label": "What are the key points?","is_required": true,"field":{"name": "key_points","type": "textarea","placeholder": "e.g. Benefit of new AI technologies"}}]','prompt' => 'Write interesting story ideas in english language for medium.com based on these keywords {_key_points_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'story-ideas','template_category_id' => '8','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '59','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'TikTok Video Script','description' => NULL,'slug' => 'tiktok-video-script','icon' => NULL,'fields' => '[{"label": "What are the key points?","is_required": true,"field":{"name": "key_points","type": "textarea","placeholder": "e.g. Fun, prank, popular tune"}}]','prompt' => 'Write interesting tiktok video script in english language based on these keywords {_key_points_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'tiktok-video-script','template_category_id' => '9','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '60','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'TikTok Video Caption','description' => NULL,'slug' => 'tiktok-video-caption','icon' => NULL,'fields' => '[{"label": "About what is the video?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the video"}}]','prompt' => '','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'tiktok-video-caption','template_category_id' => '9','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '61','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Video Ideas','description' => NULL,'slug' => 'video-ideas','icon' => NULL,'fields' => '[{"label": "What are the key points?","is_required": true,"field":{"name": "key_points","type": "textarea","placeholder": "e.g. Fun, prank, popular tune"}}]','prompt' => 'Write interesting video ideas in english language based on these keywords {_key_points_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'video-ideas','template_category_id' => '9','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '62','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Instagram Story Ideas','description' => NULL,'slug' => 'instagram-story-ideas','icon' => NULL,'fields' => '[{"label": "About what is the story?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Write interesting instagram story ideas in english language based on this description {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'instagram-story-ideas','template_category_id' => '10','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '63','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Instagram Post Ideas','description' => NULL,'slug' => 'instagram-post-ideas','icon' => NULL,'fields' => '[{"label": "About what is the story?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Write interesting instagram post ideas in english language based on this description {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'instagram-post-ideas','template_category_id' => '10','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '64','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Instagram Reel Ideas','description' => NULL,'slug' => 'instagram-reel-ideas','icon' => NULL,'fields' => '[{"label": "About what is the story?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Write interesting instagram reel ideas in english language based on this description {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'instagram-reel-ideas','template_category_id' => '10','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '65','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Career','description' => NULL,'slug' => 'career','icon' => NULL,'fields' => '[{"label": "About what is the story?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Write success story of career in english language based on this description {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'career','template_category_id' => '11','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '66','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Business','description' => NULL,'slug' => 'business','icon' => NULL,'fields' => '[{"label": "About what is the story?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Write success story of business in english language based on this description {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'business','template_category_id' => '11','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '67','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Start up','description' => NULL,'slug' => 'start-up','icon' => NULL,'fields' => '[{"label": "About what is the story?","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Write success story of start up in english language based on this description {_about_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'start-up','template_category_id' => '11','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '68','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Matrimonial Website','description' => NULL,'slug' => 'matrimonial-website','icon' => NULL,'fields' => '[{"label": "What are partners name?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": "e.g. Bride: Tanu, Bridegroom: Manu"}},{"label": "Description of their journey","is_required": true,"field":{"name": "about", "slug":"about","type": "textarea","placeholder": "Type description of the story"}}]','prompt' => 'Write success story for matrimonial website in english language based on this description {_about_} Partners name {_name_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'matrimonial-website','template_category_id' => '11','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '69','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Blog Post SEO Meta Description','description' => NULL,'slug' => 'blog-post-seo-meta-description','icon' => NULL,'fields' => '[{"label": "What is your blog title?","is_required": true,"field":{"name": "title", "slug":"title","type": "text","placeholder": ""}},{"label": "Description of your blog","is_required": true,"field":{"name": "description", "slug":"description","type": "textarea","placeholder": "Type description of the blog"}}]','prompt' => 'Write seo friendly meta description in english language for this blog {_title_} .Blog Description {_description_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'blog-post-seo-meta-description','template_category_id' => '12','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '70','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Home Page SEO Meta Description','description' => NULL,'slug' => 'home-page-seo-meta-description','icon' => NULL,'fields' => '[{"label": "What is your website branding name?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": ""}},{"label": "Description of your website","is_required": true,"field":{"name": "description", "slug":"description","type": "textarea","placeholder": "Type description of the website"}}]','prompt' => 'Write seo friendly meta description in english language for this website {_name_}. Website Description {_description_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'home-page-seo-meta-description','template_category_id' => '12','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '71','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Product Page SEO Meta Description','description' => NULL,'slug' => 'product-page-seo-meta-description','icon' => NULL,'fields' => '[{"label": "What is your product name?","is_required": true,"field":{"name": "name","slug":"name","type": "text","placeholder": ""}},{"label": "Description of your product","is_required": true,"field":{"name": "description", "slug":"description","type": "textarea","placeholder": "Type description of the product"}}]','prompt' => 'Write seo friendly meta description in english language for this product {_name_} .Product Description {_description_}','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => 'product-page-seo-meta-description','template_category_id' => '12','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-04-16 11:48:06','updated_at' => '2024-06-12 12:49:25'),
            array('id' => '72','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Design system -25','description' => 'ThemeTags-Design System Fully auto layout and Color Variable Maintained','slug' => 'design-system-25-a0o6G1X0C2S1Z4Q','icon' => NULL,'fields' => '[{"label":"English","is_required":true,"field":{"name":"Input","type":"text","slug":"input"}}]','prompt' => 'Design system 2025','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => NULL,'template_category_id' => '13','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2024-12-31 12:08:17','updated_at' => '2025-01-28 06:49:19'),
            array('id' => '73','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Promotional','description' => 'Promotional email template for ecommerce web development app','slug' => 'promotional-P2u6y2a3A8u3d9U','icon' => '<link rel= "stylesheet" href= "https://maxst.icons8.com/vue-static/landings/line-awesome/font-awesome-line-awesome/css/all.min.css" >','fields' => '[{"label":"Conscious","is_required":true,"field":{"name":"Email Template","type":"text","slug":"email_template"}}]','prompt' => 'Write a Promotional email template for ecommerce web development app','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => NULL,'template_category_id' => '2','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2025-01-01 14:06:52','updated_at' => '2025-01-01 14:08:33'),
            array('id' => '74','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Promotional Mail','description' => 'Promotional email template for an eCommerce business without a website','slug' => 'promotional-mail-F2O9N7y1S6L7f0z','icon' => '<link rel= "stylesheet" href= "https://maxst.icons8.com/vue-static/landings/line-awesome/font-awesome-line-awesome/css/all.min.css" >','fields' => '[{"label":"Best","is_required":true,"field":{"name":"Email Template","type":"text","slug":"email_template"}}]','prompt' => 'Compose a warm, personalized welcome email to greet new newsletter subscribers. Thank them for joining and entice them with a sneak peek into [your valuable upcoming content','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => NULL,'template_category_id' => '2','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2025-01-01 14:17:36','updated_at' => '2025-01-01 14:22:29'),
            array('id' => '75','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'Email -2','description' => 'email to sell your web design services','slug' => 'email-2-x1j5a9O3e0Y0n7f','icon' => NULL,'fields' => '[{"label":"Conscious","is_required":true,"field":{"name":"Email Template","type":"text","slug":"email_template"}}]','prompt' => 'Write an email that promotes the web design services of a company called ThemeTags, which offers high-quality and custom web development, UI/UX design, and mobile app development.','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => NULL,'template_category_id' => '2','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2025-01-01 14:27:14','updated_at' => '2025-01-28 06:49:22'),
            array('id' => '76','is_default' => '1','is_favourite' => '0','is_popular' => '0','template_name' => 'TT Template','description' => 'Test','slug' => 'tt-template-h4F9d5m6k5J0u1w','icon' => 'hash','fields' => '[{"label":"TT Story","is_required":true,"field":{"name":"tt_input","type":"text","slug":"tt_input"}},{"label":"TT About","is_required":true,"field":{"name":"tt_about","type":"textarea","slug":"tt_about"}}]','prompt' => 'Tell me about ThemeForest html item submission','total_words_generated' => '0','total_view' => '0','total_favourite' => '0','code' => NULL,'template_category_id' => '16','user_id' => '1','is_active' => '1','created_by_id' => '1','updated_by_id' => '1','deleted_at' => NULL,'created_at' => '2025-01-21 12:57:42','updated_at' => '2025-01-28 06:49:24')
        );


        DB::table('templates')->delete();
        DB::table('templates')->insert($templates);
    }
}
